/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.blocks.BlockInkedSlab;
import com.cibernet.splatcraft.blocks.BlockInkedWool;
import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.network.PacketInkLandParticles;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkedBlock;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInked
extends BlockInkColor
implements IInked {
    private boolean isGlittery;

    public BlockInked(String registryName, boolean isGlittery) {
        super(Material.field_151571_B);
        this.func_149663_c("inkedBlock");
        this.setRegistryName(registryName);
        this.func_149675_a(true);
        if (isGlittery) {
            this.func_149715_a(0.4f);
        }
        this.isGlittery = isGlittery;
    }

    public BlockInked() {
        this("inked_block", false);
    }

    @Override
    public boolean canInk() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return true;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean countsTowardsScore() {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            return true;
        }
        int color = InkColors.INK_BLACK.getColor();
        if (world.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)world.func_175625_s(pos)).getColor();
        }
        SplatCraftParticleSpawner.spawnInkParticle(entity.field_70165_t + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, color, 1.5f);
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        int color = InkColors.INK_BLACK.getColor();
        if (worldObj.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)worldObj.func_175625_s(pos)).getColor();
        }
        SplatCraftPacketHandler.instance.sendToAllAround((IMessage)new PacketInkLandParticles(color, numberOfParticles, entity.field_70163_u, (Entity)entity), new NetworkRegistry.TargetPoint(worldObj.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1024.0));
        return true;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
            IBlockState savedState = te.getSavedState();
            if (savedState.func_177230_c() == this) {
                return ItemStack.field_190927_a;
            }
            return savedState.func_177230_c().func_185473_a(worldIn, pos, state);
        }
        return ItemStack.field_190927_a;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
            IBlockState savedState = te.getSavedState();
            if (savedState.func_177230_c() == this) {
                super.func_180653_a(worldIn, pos, savedState, chance, fortune);
            }
            savedState.func_177230_c().func_180653_a(worldIn, pos, savedState, chance, fortune);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180659_g(state, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        InkColors color = InkColors.getByColor(te.getColor());
        if (color == null) {
            return super.func_180659_g(state, worldIn, pos);
        }
        return color.getMapColor();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)world.func_175625_s(pos);
            IBlockState savedState = te.getSavedState();
            if (savedState.func_177230_c() == this) {
                return super.getPickBlock(state, target, world, pos, player);
            }
            return savedState.func_177230_c().getPickBlock(savedState, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_176195_g(blockState, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        if (te.getSavedState().func_177230_c() instanceof BlockInkedSlab) {
            return this.field_149782_v;
        }
        return te.getSavedState().func_177230_c().func_176195_g(te.getSavedState(), worldIn, pos);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        return te.getSavedState().func_177230_c().func_180647_a(te.getSavedState(), player, worldIn, pos);
    }

    public float getExplosionResistance(World worldIn, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.getExplosionResistance(worldIn, pos, exploder, explosion);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        try {
            return te.getSavedState().func_177230_c().getExplosionResistance(worldIn, pos, exploder, explosion);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityInkedBlock) {
            state = ((TileEntityInkedBlock)te).getSavedState();
            Block savedBlock = state.func_177230_c();
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (savedBlock.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ItemStack itemstack = SplatCraftUtils.getSilkTouchDropFromBlock(savedBlock, state);
                if (!itemstack.func_190926_b()) {
                    items.add(itemstack);
                }
                ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
                for (ItemStack item : items) {
                    BlockInked.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
                }
            } else {
                this.harvesters.set(player);
                int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                savedBlock.func_176226_b(worldIn, pos, state, i);
                this.harvesters.set(null);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (SplatCraftGamerules.getGameruleValue("inkDecay")) {
            this.clearInk(worldIn, pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(fromPos).func_185904_a().equals(Material.field_151586_h)) {
            this.clearInk(worldIn, pos);
        }
    }

    @Override
    public boolean clearInk(World worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
            worldIn.func_180501_a(pos, te.getSavedState(), 3);
            if (te.getSavedState().func_177230_c() instanceof BlockInkedWool) {
                worldIn.func_175690_a(pos, (TileEntity)((TileEntityColor)te.getSavedState().func_177230_c().createTileEntity(worldIn, te.getSavedState())).setColor(te.getSavedColor()));
            }
        } else {
            worldIn.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 3);
        }
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isGlittery ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityInkedBlock();
    }
}

