/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.network.PacketInkLandParticles;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkedBlock;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPurpurSlab;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInkedSlab
extends BlockSlab
implements IInked {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    private boolean isGlittery;

    public BlockInkedSlab(String registryName, boolean isGlittery) {
        super(Material.field_151571_B);
        this.setRegistryName(registryName);
        this.func_149663_c("inkedSlab");
        this.func_149675_a(true);
        BlockInkColor.blocks.add((Block)this);
        if (isGlittery) {
            this.func_149715_a(0.4f);
        }
        this.isGlittery = isGlittery;
    }

    public BlockInkedSlab() {
        this("inked_slab", false);
    }

    public boolean func_176552_j() {
        return false;
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return BlockPurpurSlab.Variant.DEFAULT;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180659_g(state, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        InkColors color = InkColors.getByColor(te.getColor());
        if (color == null) {
            return super.func_180659_g(state, worldIn, pos);
        }
        return color.getMapColor();
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K) {
            return true;
        }
        int color = InkColors.INK_BLACK.getColor();
        if (world.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)world.func_175625_s(pos)).getColor();
        }
        SplatCraftParticleSpawner.spawnInkParticle(entity.field_70165_t + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, color, 1.5f);
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        int color = InkColors.INK_BLACK.getColor();
        if (worldObj.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)worldObj.func_175625_s(pos)).getColor();
        }
        SplatCraftPacketHandler.instance.sendToAllAround((IMessage)new PacketInkLandParticles(color, numberOfParticles, entity.field_70163_u, (Entity)entity), new NetworkRegistry.TargetPoint(worldObj.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1024.0));
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)world.func_175625_s(pos);
            IBlockState savedState = te.getSavedState();
            if (savedState.func_177230_c() == this) {
                return super.getPickBlock(state, target, world, pos, player);
            }
            return savedState.func_177230_c().getPickBlock(savedState, target, world, pos, player);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_176195_g(blockState, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        if (te.getSavedState().func_177230_c() instanceof BlockInkedSlab) {
            return this.field_149782_v;
        }
        return te.getSavedState().func_177230_c().func_176195_g(te.getSavedState(), worldIn, pos);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        return te.getSavedState().func_177230_c().func_180647_a(te.getSavedState(), player, worldIn, pos);
    }

    public float getExplosionResistance(World worldIn, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.getExplosionResistance(worldIn, pos, exploder, explosion);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        try {
            return te.getSavedState().func_177230_c().getExplosionResistance(worldIn, pos, exploder, explosion);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
            IBlockState savedState = te.getSavedState();
            if (savedState.func_177230_c() == this) {
                super.func_180653_a(worldIn, pos, savedState, chance, fortune);
            }
            savedState.func_177230_c().func_180653_a(worldIn, pos, savedState, chance, fortune);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityInkedBlock) {
            state = ((TileEntityInkedBlock)te).getSavedState();
            Block savedBlock = state.func_177230_c();
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            if (savedBlock.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ItemStack itemstack = SplatCraftUtils.getSilkTouchDropFromBlock(savedBlock, state);
                if (!itemstack.func_190926_b()) {
                    items.add(itemstack);
                }
                ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
                for (ItemStack item : items) {
                    BlockInkedSlab.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
                }
            } else {
                this.harvesters.set(player);
                int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
                savedBlock.func_176226_b(worldIn, pos, state, i);
                this.harvesters.set(null);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (SplatCraftGamerules.getGameruleValue("inkDecay")) {
            this.clearInk(worldIn, pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(fromPos).func_185904_a().equals(Material.field_151586_h)) {
            this.clearInk(worldIn, pos);
        }
    }

    @Override
    public boolean clearInk(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock) {
            TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
            worldIn.func_180501_a(pos, te.getSavedState().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)), 3);
        } else {
            worldIn.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 3);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isGlittery ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityInkedBlock();
    }

    @Override
    public boolean canInk() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return true;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean countsTowardsScore() {
        return true;
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String func_176610_l() {
            return "default";
        }
    }
}

