/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.blocks.BlockInkwell;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkedBlock;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockInkedWool
extends BlockInkColor {
    public BlockInkedWool(String unlocName, String registryName) {
        super(Material.field_151580_n);
        this.func_149663_c(unlocName);
        this.setRegistryName(registryName);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.8f);
        this.canInk = true;
        this.dropColored = true;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(SplatCraftUtils.getColorName(BlockInkwell.getInkColor(stack)));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        ArrayList items = new ArrayList();
        ItemStack itemstack = new ItemStack((Block)this);
        if (te instanceof TileEntityColor) {
            ColorItemUtils.setInkColor(itemstack, ((TileEntityColor)te).getColor());
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        BlockInkedWool.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int color = SplatCraft.DEFAULT_INK;
        if (world.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)world.func_175625_s(pos)).getColor();
        }
        return ColorItemUtils.setInkColor(super.getPickBlock(state, target, world, pos, player), color);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180659_g(state, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        InkColors color = InkColors.getByColor(te.getColor());
        if (color == null) {
            return super.func_180659_g(state, worldIn, pos);
        }
        return color.getMapColor();
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemShears) {
            return 0.95f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }
}

