/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.tileentities.TileEntityStageBarrier;
import com.cibernet.splatcraft.utils.ClientUtils;
import com.cibernet.splatcraft.utils.SplatCraftDamageSource;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSCBarrier
extends Block {
    boolean damagesPlayer;
    boolean fancy;
    final ResourceLocation FANCY_TEXTURE;
    final ResourceLocation MODEL_TEXTURE;
    private static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.05, 0.05, 0.05, 0.95, 0.95, 0.95);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(-0.05, -0.05, -0.05, 1.05, 1.05, 1.05);
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockSCBarrier(String unlocName, String registryName, boolean damagesPlayer) {
        super(Material.field_175972_I);
        this.func_149663_c(unlocName);
        this.setRegistryName(registryName);
        this.func_149647_a(TabSplatCraft.main);
        this.func_149722_s();
        this.func_149752_b(6000001.0f);
        this.func_149649_H();
        this.field_149785_s = true;
        this.damagesPlayer = damagesPlayer;
        this.MODEL_TEXTURE = new ResourceLocation("splatcraft", "textures/models/" + registryName + ".png");
        this.FANCY_TEXTURE = new ResourceLocation("splatcraft", "textures/models/" + registryName + "_fancy.png");
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityStageBarrier();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.damagesPlayer ? COLLISION_BOX : DEFAULT_AABB;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        if (ClientUtils.getClientPlayer().func_184812_l_()) {
            return super.func_180640_a(state, worldIn, pos);
        }
        return EMPTY_AABB;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityPlayer && this.damagesPlayer) {
            entityIn.func_70097_a(SplatCraftDamageSource.VOID_DAMAGE, Float.MAX_VALUE);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ResourceLocation getModelTexture() {
        return ClientUtils.getFancyGraphics() ? this.FANCY_TEXTURE : this.MODEL_TEXTURE;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGraphicsLevel(boolean fancy) {
        this.fancy = fancy;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }
}

