/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.tileentities.TileEntitySunkenCrate;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSunkenCrate
extends BlockInkColor {
    public static final PropertyInteger STATE = PropertyInteger.func_177719_a((String)"state", (int)0, (int)4);
    public static final ResourceLocation STORAGE_SUNKEN_CRATE = new ResourceLocation("splatcraft", "storage/sunken_crate");

    public BlockSunkenCrate() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("sunkenCrate");
        this.setRegistryName("sunken_crate");
        this.func_149647_a(TabSplatCraft.main);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)STATE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STATE, (Comparable)Integer.valueOf(meta % 4));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STATE);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntitySunkenCrate) {
            TileEntitySunkenCrate te = (TileEntitySunkenCrate)worldIn.func_175625_s(pos);
            int hp = te.getState();
            return this.func_176223_P().func_177226_a((IProperty)STATE, (Comparable)Integer.valueOf(hp));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (SplatCraftGamerules.getGameruleValue("dropCrateLootWhenMined") && worldIn.func_82736_K().func_82766_b("doTileDrops")) {
            BlockSunkenCrate.dropLoot(worldIn, pos);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySunkenCrate();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static void dropLoot(World world, BlockPos pos) {
        LootContext.Builder contextBuilder = new LootContext.Builder((WorldServer)world);
        List loot = world.func_184146_ak().func_186521_a(STORAGE_SUNKEN_CRATE).func_186462_a(world.field_73012_v, contextBuilder.func_186471_a());
        for (ItemStack stack : loot) {
            SplatCraftUtils.dropItem(world, pos, stack, false);
        }
    }
}

