/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IInked {
    public boolean canInk();

    public boolean canDamage();

    public boolean canSwim();

    public boolean countsTowardsScore();

    default public boolean canClimb() {
        return this.canSwim();
    }

    default public boolean clearInk(World worldIn, BlockPos pos) {
        return false;
    }

    default public int getDefaultColor() {
        return SplatCraft.DEFAULT_INK;
    }

    default public int getColor(World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        return te instanceof TileEntityColor ? ((TileEntityColor)te).getColor() : -1;
    }

    public static boolean tryTouchWater(World worldIn, BlockPos pos, IBlockState state) {
        boolean touchingWater = IInked.touchingWater(worldIn, pos);
        if (touchingWater && worldIn.func_180495_p(pos).func_177230_c() instanceof IInked) {
            ((IInked)worldIn.func_180495_p(pos).func_177230_c()).clearInk(worldIn, pos);
        }
        return touchingWater;
    }

    public static boolean touchingWater(World worldIn, BlockPos pos) {
        boolean touchingWater = false;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos;
            if (enumfacing == EnumFacing.DOWN || worldIn.func_180495_p(blockpos = pos.func_177972_a(enumfacing)).func_185904_a() != Material.field_151586_h) continue;
            touchingWater = true;
            break;
        }
        return touchingWater;
    }
}

