/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities.classes;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlasterProjectile
extends EntityInkProjectile {
    private int lifespan = 1;

    public EntityBlasterProjectile(World worldIn, EntityLivingBase throwerIn, int color, float damage, float splashDamage, int lifespan) {
        super(worldIn, throwerIn, color, damage);
        this.lifespan = lifespan;
        this.splashDamage = splashDamage;
        this.setTrail(false);
    }

    public EntityBlasterProjectile(World world) {
        super(world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            --this.lifespan;
        }
        if (this.lifespan <= 0) {
            SplatCraftUtils.createInkExplosion(this.field_70170_p, this, pos, this.getProjectileSize() / 2.0f, this.splashDamage, this.getColor(), this.glowingInk);
            this.func_70106_y();
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        } else {
            for (double y = this.field_70163_u; y >= 0.0 && this.field_70163_u - y <= 8.0; y -= 1.0) {
                BlockPos inkPos = new BlockPos(this.field_70165_t, y, this.field_70161_v);
                if (SplatCraftUtils.canInkPassthrough(this.field_70170_p, inkPos)) continue;
                SplatCraftUtils.createInkExplosion(this.field_70170_p, this, inkPos.func_177984_a(), this.getProjectileSize() / 3.0f, 0.0f, this.getColor(), this.glowingInk);
                SplatCraftUtils.createInkExplosion(this.field_70170_p, this, pos, this.getProjectileSize() / 3.0f, 0.0f, this.getColor(), this.glowingInk);
                break;
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lifespan = compound.func_74762_e("lifespan");
        this.splashDamage = compound.func_74760_g("splashDamage");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("lifespan", this.lifespan);
        compound.func_74776_a("splashDamage", this.splashDamage);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            SplatCraftParticleSpawner.spawnInksplosionParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, this.getColor(), this.getProjectileSize() * 2.0f);
        }
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        super.onImpact(result);
        if (result.field_72313_a.equals((Object)RayTraceResult.Type.ENTITY) && (this.thrower != null && result.field_72308_g != this.thrower && this.thrower.func_184187_bx() != result.field_72308_g && result.field_72308_g instanceof EntityLivingBase || result.field_72308_g == null || this.thrower == null)) {
            SplatCraftUtils.createInkExplosion(this.field_70170_p, this, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.getProjectileSize() / 2.0f, this.splashDamage, this.getColor(), this.glowingInk);
        }
    }

    public boolean func_189652_ae() {
        return true;
    }
}

