/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities.classes;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityChargerProjectile
extends EntityInkProjectile {
    private int lifespan = 1;

    public EntityChargerProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityChargerProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityChargerProjectile(World worldIn, EntityLivingBase throwerIn, int color, float damage, int lifespan) {
        super(worldIn, throwerIn, color, damage);
        this.lifespan = lifespan;
        this.setTrail(false);
        this.setPierce(true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (double y = this.field_70163_u; y >= 0.0 && this.field_70163_u - y <= 16.0; y -= 1.0) {
            BlockPos inkPos = new BlockPos(this.field_70165_t, y, this.field_70161_v);
            if (SplatCraftUtils.canInkPassthrough(this.field_70170_p, inkPos)) continue;
            SplatCraftUtils.createInkExplosion(this.field_70170_p, this, inkPos.func_177984_a(), this.getProjectileSize() / 2.0f, 0.0f, this.getColor(), this.glowingInk);
            SplatCraftUtils.createInkExplosion(this.field_70170_p, this, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.getProjectileSize() / 2.0f, 0.0f, this.getColor(), this.glowingInk);
            break;
        }
        if (!this.field_70170_p.field_72995_K) {
            --this.lifespan;
        }
        if (this.lifespan <= 0) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lifespan = compound.func_74762_e("lifespan");
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("lifespan", this.lifespan);
    }

    public boolean func_189652_ae() {
        return true;
    }
}

