/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities.classes;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.registries.SplatCraftItems;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftDamageSource;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySquidBumper
extends EntityLivingBase {
    private static final float maxInkHealth = 20.0f;
    public static final int maxRespawnTime = 60;
    public boolean inkproof = false;
    private static final Iterable<ItemStack> armorInv = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    private static final Predicate<Entity> IS_RIDEABLE_MINECART = entity -> entity instanceof EntityMinecart && ((EntityMinecart)entity).canBeRidden();
    private static final DataParameter<Float> RESPAWN_TIME = EntityDataManager.func_187226_a(EntitySquidBumper.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR = EntityDataManager.func_187226_a(EntitySquidBumper.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPLAT_HEALTH = EntityDataManager.func_187226_a(EntitySquidBumper.class, (DataSerializer)DataSerializers.field_187193_c);
    public long punchCooldown;
    public long hurtCooldown;

    public EntitySquidBumper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    public EntitySquidBumper(World world, double x, double y, double z, int color) {
        super(world);
        this.func_70107_b(x, y, z);
        this.setColor(color);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)Float.valueOf(SplatCraft.DEFAULT_INK));
        this.field_70180_af.func_187214_a(SPLAT_HEALTH, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(RESPAWN_TIME, (Object)Float.valueOf(0.0f));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.field_70172_ad > this.field_70771_an) {
            return false;
        }
        if (source instanceof SplatCraftDamageSource) {
            if (this.getInkHealth() > 0.0f && this.field_70172_ad <= 0) {
                this.ink(amount);
                if (this.getInkHealth() <= 0.0f) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)34);
                }
            }
            return false;
        }
        if (source.equals(DamageSource.field_76380_i)) {
            this.func_70106_y();
            return false;
        }
        if (!this.func_180431_b(source)) {
            if (source.equals(DamageSource.field_76372_a)) {
                if (this.func_70027_ad()) {
                    this.damage(0.15f);
                } else {
                    this.func_70015_d(5);
                }
                return false;
            }
            if (source.equals(DamageSource.field_76370_b)) {
                this.damage(4.0f);
                return false;
            }
            if (source.func_76364_f() instanceof EntityArrow) {
                this.func_70106_y();
                this.dropAsItem();
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                return false;
            }
            if (source.func_180136_u()) {
                this.playBrokenSound();
                this.playParticles();
                this.func_70106_y();
                return false;
            }
            long i = this.field_70170_p.func_82737_E();
            if (i - this.punchCooldown > 5L && !"arrow".equals(source.func_76355_l())) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                this.punchCooldown = i;
            } else {
                this.dropAsItem();
                this.playParticles();
                this.func_70106_y();
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 31: {
                if (!this.field_70170_p.field_72995_K) break;
                this.hurtCooldown = this.field_70170_p.func_82737_E();
                break;
            }
            case 32: {
                if (!this.field_70170_p.field_72995_K) break;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.punchCooldown = this.field_70170_p.func_82737_E();
                break;
            }
            case 34: {
                if (!this.field_70170_p.field_72995_K) break;
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, this.func_184176_by(), 0.5f, 20.0f, false);
                this.playPopParticles();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_70636_d() {
        TileEntityColor te;
        super.func_70636_d();
        this.field_70172_ad = Math.max(this.field_70172_ad - 1, 0);
        if (this.getRespawnTime() > 1) {
            this.setRespawnTime(this.getRespawnTime() - 1);
        } else if (this.getRespawnTime() == 1) {
            this.respawn();
        }
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
        if (this.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell) && this.field_70170_p.func_175625_s(pos) instanceof TileEntityColor && (te = (TileEntityColor)this.field_70170_p.func_175625_s(pos)).getColor() != this.getColor()) {
            this.setColor(te.getColor());
        }
    }

    public boolean func_70067_L() {
        return this.getInkHealth() > 0.0f;
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.getInkHealth() > 0.0f) {
            this.func_70108_f(entityIn);
        }
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - this.field_70165_t), (double)(d1 = entityIn.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            d0 *= 3.0;
            d1 *= 3.0;
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ColorItemUtils.setInkColor(new ItemStack(SplatCraftItems.squidBumper), this.getColor());
    }

    private void updateBoundingBox() {
        this.func_70105_a(this.field_70130_N, this.getRespawnTime() > 0 ? 1.0f : this.field_70131_O);
    }

    private void damage(float damage) {
        float health = this.func_110143_aJ() - damage;
        if (health < 0.5f) {
            this.func_70106_y();
        } else {
            this.func_70606_j(health);
        }
    }

    private void ink(float damage) {
        if (!this.inkproof) {
            this.setInkHealth(this.getInkHealth() - damage);
            this.setRespawnTime(60);
            this.field_70170_p.func_72960_a((Entity)this, (byte)31);
            this.hurtCooldown = this.field_70170_p.func_82737_E();
            this.field_70172_ad = this.field_70771_an;
        }
    }

    private void respawn() {
        if (this.getInkHealth() <= 0.0f) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_193808_ex, this.func_184176_by(), 1.0f, 4.0f);
        }
        this.setInkHealth(20.0f);
        this.setRespawnTime(0);
    }

    private void dropAsItem() {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)new BlockPos((Entity)this), (ItemStack)ColorItemUtils.setInkColor(new ItemStack(SplatCraftItems.squidBumper), this.getColor()));
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 10, (double)(this.field_70130_N / 4.0f), (double)(this.field_70131_O / 4.0f), (double)(this.field_70130_N / 4.0f), 0.05, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150325_L.func_176223_P())});
        }
    }

    private void playPopParticles() {
        for (int i = 0; i < 10; ++i) {
            SplatCraftParticleSpawner.spawnInkParticle(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.getColor(), 2.0f);
        }
        SplatCraftParticleSpawner.spawnInksplosionParticle(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, 0.0, 0.0, 0.0, this.getColor(), 2.0f);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Color")) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_74764_b("InkHealth")) {
            this.setInkHealth(compound.func_74760_g("InkHealth"));
        }
        if (compound.func_74764_b("RespawnTime")) {
            this.setRespawnTime(compound.func_74762_e("RespawnTime"));
        }
        if (compound.func_74764_b("Inkproof")) {
            this.inkproof = compound.func_74767_n("Inkproof");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Color", this.getColor());
        compound.func_74768_a("RespawnTime", this.getRespawnTime());
        compound.func_74776_a("InkHealth", this.getInkHealth());
        compound.func_74757_a("Inkproof", this.inkproof);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b("Color")) {
            this.setColor(compound.func_74762_e("Color"));
        } else {
            this.setColor(InkColors.getRandomStarterColor().getColor());
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74768_a("Color", this.getColor());
        return super.func_189511_e(compound);
    }

    public int getColor() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR)).intValue();
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)Float.valueOf(color));
    }

    public float getInkHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SPLAT_HEALTH)).floatValue();
    }

    public void setInkHealth(float health) {
        this.field_70180_af.func_187227_b(SPLAT_HEALTH, (Object)Float.valueOf(health));
    }

    public int getRespawnTime() {
        return ((Float)this.field_70180_af.func_187225_a(RESPAWN_TIME)).intValue();
    }

    public void setRespawnTime(int time) {
        this.field_70180_af.func_187227_b(RESPAWN_TIME, (Object)Float.valueOf(time));
    }

    public Iterable<ItemStack> func_184193_aE() {
        return armorInv;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }
}

