/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities.models;

import com.cibernet.splatcraft.items.ItemDualieBase;
import com.cibernet.splatcraft.items.ItemSlosherBase;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;

public class ModelPlayerOverride
extends ModelPlayer {
    private ModelBase oldModel;
    private float thirdPersonPartialTicks;

    public ModelPlayerOverride(ModelBase oldModel, float modelSize, boolean smallArmsIn) {
        super(modelSize, smallArmsIn);
        this.oldModel = oldModel;
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.func_78086_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        this.oldModel.func_78086_a(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        this.thirdPersonPartialTicks = partialTickTime;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        this.oldModel.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        EntityPlayer player = (EntityPlayer)entityIn;
        if (player == null) {
            return;
        }
        boolean isClient = player.func_145782_y() == Minecraft.func_71410_x().field_71439_g.func_145782_y();
        ItemStack stack = player.func_184607_cu();
        Item activeItem = stack.func_77973_b();
        int useTime = activeItem.func_77626_a(stack) - player.func_184605_cv();
        if (useTime > 0) {
            EnumHandSide handSide = player.func_184591_cq();
            if (player.func_184600_cs() == EnumHand.OFF_HAND) {
                handSide = handSide.func_188468_a();
            }
            ModelRenderer mainHand = this.func_187074_a(handSide);
            ModelRenderer offHand = this.func_187074_a(handSide.func_188468_a());
            ItemStack offhandStack = player.func_184586_b(player.func_184614_ca().equals(player.func_184607_cu()) ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
            if (!(activeItem instanceof ItemWeaponBase)) {
                return;
            }
            EnumAnimType type = ((ItemWeaponBase)activeItem).getAnimType();
            switch (type) {
                case DUALIES: {
                    if (offhandStack.func_77973_b() instanceof ItemDualieBase) {
                        offHand.field_78796_g = -0.1f + this.field_78116_c.field_78796_g;
                        offHand.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                    }
                }
                case SHOOTER: {
                    mainHand.field_78796_g = -0.1f + this.field_78116_c.field_78796_g;
                    mainHand.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
                    break;
                }
                case ROLLER: {
                    mainHand.field_78795_f = -0.26415926f;
                    mainHand.field_78796_g = 0.0f;
                    mainHand.field_78808_h = 0.0f;
                    break;
                }
                case CHARGER: {
                    if (handSide == EnumHandSide.LEFT) {
                        this.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                        break;
                    }
                    this.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    break;
                }
                case BUCKET: {
                    float animTime = ((ItemSlosherBase)activeItem).startupTicks * 2;
                    mainHand.field_78796_g = 0.0f;
                    mainHand.field_78795_f = -0.36f;
                    float angle = (float)useTime / 1.5f * (animTime / 6.0f);
                    if (!(angle < 6.5f)) break;
                    mainHand.field_78795_f = MathHelper.func_76134_b((float)(angle * 0.6662f)) * 2.0f * 0.5f;
                }
            }
            this.field_178734_a.field_78795_f = this.field_178724_i.field_78795_f;
            this.field_178734_a.field_78796_g = this.field_178724_i.field_78796_g;
            this.field_178732_b.field_78796_g = this.field_178723_h.field_78796_g;
            this.field_178732_b.field_78795_f = this.field_178723_h.field_78795_f;
        }
    }

    public static enum EnumAnimType {
        NONE,
        SHOOTER,
        ROLLER,
        CHARGER,
        DUALIES,
        BUCKET;

    }
}

