/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities.renderers;

import com.cibernet.splatcraft.entities.classes.EntitySquidBumper;
import com.cibernet.splatcraft.entities.models.ModelSquidBumper;
import com.cibernet.splatcraft.entities.renderers.LayerSquidBumperColor;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class RenderSquidBumper
extends RenderLivingBase<EntitySquidBumper> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("splatcraft", "textures/mobs/squid_bumper_overlay.png");

    public RenderSquidBumper(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelSquidBumper(), 0.6f);
        this.func_177094_a(new LayerSquidBumperColor(this));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntitySquidBumper entity) {
        return TEXTURE;
    }

    protected void renderEntityName(EntitySquidBumper entityIn, double x, double y, double z, String name, double distanceSq) {
        if (entityIn.func_145818_k_()) {
            super.func_188296_a((Entity)entityIn, x, y, z, name, distanceSq);
        } else {
            float health = 20.0f - entityIn.getInkHealth();
            this.func_147906_a((Entity)entityIn, (health >= 20.0f ? TextFormatting.DARK_RED : "") + String.format("%.1f", Float.valueOf(health)), x, y, z, 64);
        }
    }

    protected boolean canRenderName(EntitySquidBumper entity) {
        return entity.func_145818_k_() || entity.getInkHealth() >= 20.0f ? super.func_177070_b((EntityLivingBase)entity) && (entity.func_94059_bO() || entity == this.field_76990_c.field_147941_i) : true;
    }

    protected void applyRotations(EntitySquidBumper entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float punchTime = (float)(entityLiving.field_70170_p.func_82737_E() - entityLiving.punchCooldown) + partialTicks;
        float hurtTime = (float)(entityLiving.field_70170_p.func_82737_E() - entityLiving.hurtCooldown) + partialTicks;
        if (punchTime < 5.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(punchTime / 1.5f * (float)Math.PI)) * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (hurtTime < 5.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(hurtTime / 1.5f * (float)Math.PI)) * 3.0f), (float)1.0f, (float)0.0f, (float)1.0f);
        }
    }
}

