/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.gui;

import com.cibernet.splatcraft.gui.container.ContainerInkwellVat;
import com.cibernet.splatcraft.network.PacketSetVatOutput;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.tileentities.TileEntityInkwellVat;
import com.cibernet.splatcraft.utils.InkColors;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiInkwellVat
extends GuiContainer {
    private static final ResourceLocation TEXTURES = new ResourceLocation("splatcraft", "textures/gui/inkwell_crafting.png");
    private final InventoryPlayer player;
    private final TileEntityInkwellVat te;
    private float scroll = 0.0f;
    private List<InkColors> colorSelection;
    private int clientSelectedColor = -1;
    private boolean scrolling = false;

    public GuiInkwellVat(EntityPlayer player, TileEntityInkwellVat te) {
        super((Container)new ContainerInkwellVat(player, te));
        this.player = player.field_71071_by;
        this.te = te;
        this.clientSelectedColor = te.func_174887_a_(0);
        this.field_147000_g = 208;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.colorSelection = this.te.getColorList();
        this.clientSelectedColor = this.te.func_174887_a_(0);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        TileEntityInkwellVat inventory = this.te;
        if (inventory.func_70301_a(0).func_190926_b()) {
            this.func_73729_b(this.field_147003_i + 26, this.field_147009_r + 70, 176, 0, 16, 16);
        }
        if (inventory.func_70301_a(1).func_190926_b()) {
            this.func_73729_b(this.field_147003_i + 46, this.field_147009_r + 70, 192, 0, 16, 16);
        }
        if (inventory.func_70301_a(2).func_190926_b()) {
            this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 82, 208, 0, 16, 16);
        }
        if (inventory.func_70301_a(3).func_190926_b()) {
            this.func_73729_b(this.field_147003_i + 36, this.field_147009_r + 89, 224, 0, 16, 16);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String displayName = this.te.func_145748_c_().func_150261_e();
        this.field_146289_q.func_78276_b(displayName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayName) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        if (this.colorSelection != null) {
            boolean isScrolling;
            int sc = (int)Math.ceil(Math.max(0.0f, (float)(this.colorSelection.size() - 16) * this.scroll));
            sc += sc % 2;
            for (int i = sc; i < this.colorSelection.size() && i - sc < 16; ++i) {
                int color = this.colorSelection.get(i).getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                int x = 12 + (i - sc) / 2 * 19;
                int y = 16 + (i - sc) % 2 * 18;
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
                this.func_73729_b(x, y, 34, 220, 19, 18);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                if (i != this.clientSelectedColor) continue;
                this.func_73729_b(x, y, 34, 238, 19, 18);
            }
            boolean bl = isScrolling = this.func_146978_c(15, 55, 146, 10, mouseX, mouseY) || this.scrolling;
            if (this.colorSelection.size() - 16 > 0) {
                this.func_73729_b((int)(15.0f + 132.0f * this.scroll), 55, 241, isScrolling ? 20 : 0, 15, 10);
            } else {
                this.func_73729_b(15, 55, 241, 10, 15, 10);
            }
        } else {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(15, 55, 241, 10, 15, 10);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int selecCol = this.te.func_174887_a_(0);
        if (this.colorSelection != null) {
            int sc = (int)Math.ceil(Math.max(0.0f, (float)(this.colorSelection.size() - 16) * this.scroll));
            sc += sc % 2;
            for (int i = sc; i < this.colorSelection.size() && i - sc < 16; ++i) {
                int x = 12 + (i - sc) / 2 * 19;
                int y = 16 + (i - sc) % 2 * 18;
                if (!this.func_146978_c(x, y, 19, 18, mouseX, mouseY) || mouseButton != 0) continue;
                selecCol = i;
            }
        } else {
            selecCol = -1;
        }
        this.clientSelectedColor = selecCol;
        this.te.func_174885_b(0, selecCol);
        SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketSetVatOutput(this.te, this.te.getRecipeStack(), this.clientSelectedColor));
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseScroll = Mouse.getEventDWheel();
        float maxScroll = 0.0f;
        float sc = this.scroll;
        if (this.func_146978_c(15, 55, 146, 10, mouseX, mouseY) && Mouse.isButtonDown((int)0)) {
            this.scrolling = true;
        } else if (!Mouse.isButtonDown((int)0)) {
            this.scrolling = false;
        }
        if (this.colorSelection != null) {
            maxScroll = (float)Math.ceil((double)this.colorSelection.size() / 2.0) - 8.0f;
        }
        if (maxScroll <= 0.0f) {
            return;
        }
        if (this.scrolling) {
            sc = (float)(mouseX - (this.field_147003_i + 15)) / 146.0f;
        } else if (mouseScroll != 0) {
            sc += 1.0f / maxScroll * -Math.signum(mouseScroll);
        }
        this.scroll = Math.max(0.0f, Math.min(1.0f, sc));
    }
}

