/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.gui;

import com.cibernet.splatcraft.gui.container.ContainerPlayerInv;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.network.PacketCraftWeapon;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.recipes.RecipeSubtype;
import com.cibernet.splatcraft.recipes.RecipeType;
import com.cibernet.splatcraft.recipes.RecipesWeaponStation;
import com.cibernet.splatcraft.recipes.WeaponStationTabs;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiWeaponStation
extends GuiContainer {
    private static final ResourceLocation TEXTURES = new ResourceLocation("splatcraft", "textures/gui/weapon_crafting.png");
    private int tabPos = 0;
    private int sectionPos = 0;
    private int typePos = 0;
    private int subTypePos = 0;
    private int ingredientPos = 0;
    private int craftButtonStage = 0;
    EntityPlayer player;

    public GuiWeaponStation(EntityPlayer player, BlockPos pos) {
        super((Container)new ContainerPlayerInv((IInventory)player.field_71071_by, pos, 8, 120));
        this.player = player;
        this.field_147000_g = 202;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.craftButtonStage == 1) {
            WeaponStationTabs tab = WeaponStationTabs.values()[this.tabPos];
            List<RecipeType> typeList = RecipesWeaponStation.recipeTabs.get((Object)tab);
            List<RecipeSubtype> subtypes = typeList.get(this.typePos).getSubtypes();
            RecipeSubtype recipe = subtypes.get(this.subTypePos);
            boolean check = true;
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                if (RecipesWeaponStation.getItem(this.player, recipe.getIngredients().get(i), false)) continue;
                check = false;
                break;
            }
            if (check) {
                SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketCraftWeapon(recipe));
            }
            this.craftButtonStage = 2;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        WeaponStationTabs tab = WeaponStationTabs.values()[this.tabPos];
        List<RecipeType> section = RecipesWeaponStation.recipeTabs.get((Object)tab);
        RecipeSubtype recipe = section.get(this.typePos).getSubtypes().get(this.subTypePos);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.field_147003_i + 34), (float)(this.field_147009_r + 81), (float)100.0f);
        GlStateManager.func_179114_b((float)((float)this.player.field_70173_aa - partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        float scale = recipe.getOutput().func_77973_b() instanceof ItemWeaponBase ? 38.0f : 34.0f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(ColorItemUtils.setInkColor(recipe.getOutput().func_77946_l(), SplatCraftPlayerData.getInkColor(this.player)), recipe.getOutput().func_77973_b() instanceof ItemWeaponBase ? ItemCameraTransforms.TransformType.GUI : ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String displayName = GuiWeaponStation.getDisplayName().func_150261_e();
        this.field_146289_q.func_78276_b(displayName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayName) / 2, 21, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        RecipeSubtype recipe = RecipesWeaponStation.recipeTabs.get((Object)WeaponStationTabs.values()[this.tabPos]).get(this.typePos).getSubtypes().get(this.subTypePos);
        String subName = I18n.func_135052_a((String)recipe.getName(), (Object[])new Object[0]);
        String ingTabLabel = this.ingredientPos + 1 + "/" + (int)Math.ceil((double)recipe.getIngredients().size() / 6.0);
        this.field_146289_q.func_78276_b(subName, 34 - this.field_146289_q.func_78256_a(subName) / 2, 54, 0x404040);
        this.field_146289_q.func_78276_b(ingTabLabel, 133 - this.field_146289_q.func_78256_a(ingTabLabel) / 2, 54, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        int selectedPos;
        int yPos;
        int xPos;
        int j;
        int i2;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        WeaponStationTabs tab = WeaponStationTabs.values()[this.tabPos];
        List<RecipeType> typeList = RecipesWeaponStation.recipeTabs.get((Object)tab);
        List<RecipeSubtype> subtypes = typeList.get(this.typePos).getSubtypes();
        RecipeSubtype recipe = subtypes.get(this.subTypePos);
        int ingredientTabSize = (int)Math.ceil((double)recipe.getIngredients().size() / 6.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i2 = this.ingredientPos * 6; i2 < recipe.getIngredients().size() && i2 < this.ingredientPos * 6 + 6; ++i2) {
            ItemStack input = recipe.getIngredients().get(i2);
            j = i2 - this.ingredientPos * 6;
            xPos = 107 + j % 3 * 18;
            yPos = 64 + j / 3 * 18;
            String color = RecipesWeaponStation.getItem(this.player, input, false) ? "" : TextFormatting.RED + "";
            this.drawRecipeItemStack(input, xPos + this.field_147003_i, yPos + this.field_147009_r, color + input.func_190916_E());
        }
        for (i2 = this.sectionPos * 8; i2 < typeList.size() && i2 < this.sectionPos * 8 + 8; ++i2) {
            ItemStack stack = typeList.get(i2).getDisplayStack();
            j = i2 - this.sectionPos * 8;
            xPos = 17 + j * 18;
            yPos = 34;
            this.drawRecipeItemStack(stack, xPos + this.field_147003_i, yPos + this.field_147009_r, "");
            if (!this.func_146978_c(xPos, yPos, 16, 16, mouseX, mouseY)) continue;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int j1 = xPos + this.field_147003_i;
            int k1 = yPos + this.field_147009_r;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74518_a();
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        int ty = 220;
        if (this.craftButtonStage <= 0) {
            ty = this.func_146978_c(62, 87, 34, 12, mouseX, mouseY) ? 232 : 244;
        }
        String btnText = I18n.func_135052_a((String)"gui.weaponStation.craft", (Object[])new Object[0]);
        this.func_73729_b(62 + this.field_147003_i, 87 + this.field_147009_r, 0, ty, 34, 12);
        this.func_73731_b(this.field_146289_q, btnText, this.field_147003_i + 79 - this.field_146289_q.func_78256_a(btnText) / 2, 89 + this.field_147009_r, 0xEFEFEF);
        WeaponStationTabs[] tabs = WeaponStationTabs.values();
        for (int i3 = 0; i3 < tabs.length; ++i3) {
            int x = this.field_146294_l / 2 - (tabs.length - 1) * 11 + i3 * 22;
            ty = this.tabPos == i3 ? 216 : 236;
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
            this.func_73729_b(x - 10, this.field_147009_r - 4, 34, ty, 20, 20);
            this.field_146297_k.func_110434_K().func_110577_a(tabs[i3].getIconLocation());
            GuiWeaponStation.func_152125_a((int)(x - 8), (int)(this.field_147009_r - 2), (float)0.0f, (float)0.0f, (int)256, (int)256, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES);
        ty = subtypes.size() > 1 ? (this.func_146978_c(54, 75, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
        this.func_73729_b(this.field_147003_i + 54, this.field_147009_r + 75, 54, ty, 7, 11);
        ty = subtypes.size() > 1 ? (this.func_146978_c(7, 75, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 75, 62, ty, 7, 11);
        ty = ingredientTabSize > 1 ? (this.func_146978_c(162, 75, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
        this.func_73729_b(this.field_147003_i + 162, this.field_147009_r + 75, 54, ty, 7, 11);
        ty = ingredientTabSize > 1 ? (this.func_146978_c(97, 75, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
        this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 75, 62, ty, 7, 11);
        int maxSections = (int)Math.ceil(typeList.size() / 8);
        if (maxSections > 0) {
            ty = this.sectionPos + 1 <= maxSections ? (this.func_146978_c(162, 36, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
            this.func_73729_b(this.field_147003_i + 162, this.field_147009_r + 36, 54, ty, 7, 11);
            ty = this.sectionPos - 1 >= 0 ? (this.func_146978_c(7, 36, 7, 11, mouseX, mouseY) ? 232 : 220) : 244;
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 36, 62, ty, 7, 11);
        }
        if ((selectedPos = this.typePos - this.sectionPos * 8) < 8 && selectedPos - this.sectionPos * 8 >= 0) {
            this.field_73735_i = 500.0f;
            this.func_73729_b(13 + this.field_147003_i + selectedPos * 18, 46 + this.field_147009_r, 69, 248, 8, 8);
            this.field_73735_i = 0.0f;
        }
        this.func_191948_b(mouseX, mouseY);
        for (i = this.sectionPos * 8; i < typeList.size() && i < this.sectionPos * 8 + 8; ++i) {
            int j2 = i - this.sectionPos * 8;
            int xPos2 = 17 + j2 * 18;
            int yPos2 = 34;
            if (!this.func_146978_c(xPos2, yPos2, 16, 16, mouseX, mouseY)) continue;
            this.func_146279_a(I18n.func_135052_a((String)typeList.get(i).getDisplayName(), (Object[])new Object[0]), mouseX, mouseY);
        }
        for (i = this.ingredientPos * 6; i < recipe.getIngredients().size() && i < this.ingredientPos * 6 + 6; ++i) {
            ItemStack input = recipe.getIngredients().get(i);
            int j3 = i - this.ingredientPos * 6;
            int xPos3 = 107 + j3 % 3 * 18;
            int yPos3 = 64 + j3 / 3 * 18;
            if (j3 >= 6) break;
            if (!this.func_146978_c(xPos3, yPos3, 16, 16, mouseX, mouseY)) continue;
            this.func_146285_a(input, mouseX, mouseY);
        }
        for (i = 0; i < tabs.length; ++i) {
            int x = this.field_146294_l / 2 - (tabs.length - 1) * 11 + i * 22 + 1;
            if (!this.func_146978_c(x - 10 - this.field_147003_i, -3, 18, 18, mouseX, mouseY)) continue;
            this.func_146279_a(I18n.func_135052_a((String)tabs[i].getUnlocalizedName(), (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.func_146978_c(17, 64, 34, 34, mouseX, mouseY)) {
            this.func_146285_a(recipe.getOutput(), mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int i;
            WeaponStationTabs tab = WeaponStationTabs.values()[this.tabPos];
            List<RecipeType> typeList = RecipesWeaponStation.recipeTabs.get((Object)tab);
            List<RecipeSubtype> subtypes = typeList.get(this.typePos).getSubtypes();
            RecipeSubtype recipe = subtypes.get(this.subTypePos);
            int maxSections = (int)Math.ceil(typeList.size() / 8);
            int maxSubtype = subtypes.size() - 1;
            int ingredientTabs = recipe.getIngredients().size() / 6;
            WeaponStationTabs[] tabs = WeaponStationTabs.values();
            for (i = 0; i < tabs.length; ++i) {
                int x = this.field_146294_l / 2 - (tabs.length - 1) * 11 + i * 22 + 1;
                if (!this.func_146978_c(x - 10 - this.field_147003_i, -3, 18, 18, mouseX, mouseY)) continue;
                this.tabPos = i;
                this.sectionPos = 0;
                this.typePos = 0;
                this.subTypePos = 0;
                this.ingredientPos = 0;
                this.playButtonSound();
            }
            for (i = this.sectionPos * 8; i < typeList.size() && i < this.sectionPos * 8 + 8; ++i) {
                int j = i - this.sectionPos * 8;
                int xPos = 17 + j * 18;
                int yPos = 34;
                if (!this.func_146978_c(xPos, yPos, 16, 16, mouseX, mouseY)) continue;
                this.typePos = i;
                this.subTypePos = 0;
                this.ingredientPos = 0;
                this.playButtonSound();
            }
            if (maxSections > 0) {
                if (this.func_146978_c(162, 36, 7, 11, mouseX, mouseY)) {
                    this.sectionPos = Math.min(this.sectionPos + 1, maxSections);
                    this.playButtonSound();
                }
                if (this.func_146978_c(7, 36, 7, 11, mouseX, mouseY)) {
                    this.sectionPos = Math.max(0, this.sectionPos - 1);
                    this.playButtonSound();
                }
            }
            if (ingredientTabs > 0) {
                if (this.func_146978_c(162, 75, 7, 11, mouseX, mouseY)) {
                    this.ingredientPos = (this.ingredientPos + 1) % (ingredientTabs + 1);
                    this.playButtonSound();
                }
                if (this.func_146978_c(97, 75, 7, 11, mouseX, mouseY)) {
                    this.ingredientPos = this.ingredientPos - 1 < 0 ? ingredientTabs : this.ingredientPos - 1;
                    this.playButtonSound();
                }
            }
            if (maxSubtype > 0) {
                if (this.func_146978_c(54, 75, 7, 11, mouseX, mouseY)) {
                    this.subTypePos = (this.subTypePos + 1) % (maxSubtype + 1);
                    this.ingredientPos = 0;
                    this.playButtonSound();
                }
                if (this.func_146978_c(7, 75, 7, 11, mouseX, mouseY)) {
                    this.subTypePos = this.subTypePos - 1 < 0 ? maxSubtype : this.subTypePos - 1;
                    this.ingredientPos = 0;
                    this.playButtonSound();
                }
            }
            if (this.func_146978_c(62, 87, 34, 12, mouseX, mouseY)) {
                this.craftButtonStage = 1;
                this.playButtonSound();
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0) {
            this.craftButtonStage = 0;
        }
    }

    public static ITextComponent getDisplayName() {
        return new TextComponentTranslation("container.weaponStation", new Object[0]);
    }

    private void drawRecipeItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - 0, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    private void playButtonSound() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }
}

