/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.SplatCraftConfig;
import com.cibernet.splatcraft.entities.renderers.RenderInklingSquid;
import com.cibernet.splatcraft.handlers.SplatCraftKeyHandler;
import com.cibernet.splatcraft.items.ItemDualieBase;
import com.cibernet.splatcraft.items.ItemInkTank;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.network.PacketPlayerSetTransformed;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class ClientEventHandler {
    public static ClientEventHandler instance = new ClientEventHandler();
    public static final AttributeModifier IN_USE_SPEED_BOOST = new AttributeModifier("Weapon use speed boost", 4.0, 2).func_111168_a(false);
    private static final AttributeModifier SQUID_LAND_SPEED = new AttributeModifier("Squid in land speed penalty", 0.0, 0).func_111168_a(false);
    private static final AttributeModifier SQUID_SWIM_SPEED = new AttributeModifier("Squid swim speed boost", 0.0, 0).func_111168_a(false);
    private static final AttributeModifier ENEMY_INK_SPEED = new AttributeModifier("Enemy ink speed penalty", -0.3, 2).func_111168_a(false);
    private static RenderInklingSquid squidRenderer = null;
    private static int sneakTime = 0;
    private static boolean isSquidKeyHeld = false;

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        boolean isSquid;
        AttributeModifier noInkMod;
        AttributeModifier weaponMod;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        IAttributeInstance attributeInstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        ItemStack weapon = player.func_184607_cu();
        MovementInput input = Minecraft.func_71410_x().field_71439_g.field_71158_b;
        if (attributeInstance.func_180374_a(SQUID_LAND_SPEED)) {
            attributeInstance.func_111124_b(SQUID_LAND_SPEED);
        }
        if (attributeInstance.func_180374_a(SQUID_SWIM_SPEED) && player.field_70122_E) {
            attributeInstance.func_111124_b(SQUID_SWIM_SPEED);
        }
        if (attributeInstance.func_180374_a(IN_USE_SPEED_BOOST)) {
            attributeInstance.func_111124_b(IN_USE_SPEED_BOOST);
        }
        if (attributeInstance.func_180374_a(ENEMY_INK_SPEED)) {
            attributeInstance.func_111124_b(ENEMY_INK_SPEED);
        }
        if ((weaponMod = this.getWeaponMod(attributeInstance)) != null) {
            attributeInstance.func_111124_b(weaponMod);
        }
        if ((noInkMod = this.getNoInkWeaponMod(attributeInstance)) != null) {
            attributeInstance.func_111124_b(noInkMod);
        }
        if (SplatCraftUtils.onEnemyInk(player.field_70170_p, (EntityPlayer)player) && !attributeInstance.func_180374_a(ENEMY_INK_SPEED)) {
            attributeInstance.func_111121_a(ENEMY_INK_SPEED);
        }
        if (SplatCraftUtils.onEnemyInk(player.field_70170_p, (EntityPlayer)player, 0.5)) {
            player.field_70181_x = Math.min(player.field_70181_x, 0.05);
        }
        if (isSquid = SplatCraftPlayerData.getIsSquid((EntityPlayer)player)) {
            if (SplatCraftUtils.canSquidHide(player.field_70170_p, (EntityPlayer)player)) {
                if (!attributeInstance.func_180374_a(SQUID_SWIM_SPEED)) {
                    attributeInstance.func_111121_a(SQUID_SWIM_SPEED);
                }
                if (SplatCraftUtils.canSquidClimb(player.field_70170_p, (EntityPlayer)player) && !player.field_71075_bZ.field_75100_b) {
                    double xOff = (double)Math.signum(player.func_174811_aO().func_82601_c() == 0 ? player.field_70702_br : player.field_191988_bg) * 0.1 * (double)player.func_174811_aO().func_176743_c().func_179524_a();
                    double zOff = (double)Math.signum(player.func_174811_aO().func_82599_e() == 0 ? player.field_70702_br : player.field_191988_bg) * 0.1 * (double)player.func_174811_aO().func_176743_c().func_179524_a();
                    if (player.field_70122_E && !player.field_70170_p.func_184144_a((Entity)player, player.func_174813_aQ().func_72317_d(xOff, (double)player.field_70138_W, zOff)).isEmpty() || !player.field_70122_E) {
                        double d = player.field_70181_x;
                        float f = input.field_78901_c ? 0.46f : 0.4f;
                        if (d < (double)f) {
                            player.func_191958_b(0.0f, player.field_191988_bg, 0.0f, 0.055f * (input.field_78901_c ? 1.2f : 1.0f));
                        }
                        if (player.field_70181_x <= 0.0 && !player.func_70093_af()) {
                            player.func_191958_b(0.0f, 1.0f, 0.0f, 0.035f);
                        }
                        if (player.func_70093_af()) {
                            player.field_70181_x = Math.max(0.0, player.field_70181_x);
                        }
                    }
                }
            } else if (!attributeInstance.func_180374_a(SQUID_LAND_SPEED)) {
                attributeInstance.func_111121_a(SQUID_LAND_SPEED);
            }
        }
        if (weapon.func_77973_b() instanceof ItemWeaponBase && player.func_184587_cr() && player.field_70122_E) {
            ItemWeaponBase weaponItem = (ItemWeaponBase)weapon.func_77973_b();
            AttributeModifier speedMod = weaponItem.getSpeedModifier();
            if (!weaponItem.hasInk((EntityPlayer)player, weapon) && weaponItem.getNoInkSpeed() != null) {
                speedMod = weaponItem.getNoInkSpeed();
            }
            if (!isSquid && speedMod != null && !attributeInstance.func_180374_a(speedMod)) {
                attributeInstance.func_111121_a(speedMod);
            }
        }
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (SplatCraftPlayerData.getIsSquid((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerMovement(PlayerSPPushOutOfBlocksEvent event) {
        ItemStack stack;
        EntityPlayerSP player = (EntityPlayerSP)event.getEntityPlayer();
        MovementInput input = player.field_71158_b;
        IAttributeInstance attributeInstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (player.func_184587_cr() && !(stack = player.func_184607_cu()).func_190926_b() && stack.func_77973_b() instanceof ItemWeaponBase) {
            input.field_78902_a *= 5.0f;
            input = player.field_71158_b;
            input.field_192832_b *= 5.0f;
            if (stack.func_77973_b() instanceof ItemDualieBase && player.func_184811_cZ().func_185143_a(stack.func_77973_b(), 0.0f) > 0.0f) {
                input.field_192832_b = 0.0f;
                input.field_78902_a = 0.0f;
                input.field_78901_c = false;
                player.field_71075_bZ.field_75100_b = false;
                if (Math.abs(player.field_70159_w) <= 0.1 && Math.abs(player.field_70179_y) <= 0.1) {
                    input.field_78899_d = true;
                }
            }
        }
        if (!player.field_71075_bZ.field_75100_b) {
            if (attributeInstance.func_180374_a(SQUID_SWIM_SPEED)) {
                player.func_191958_b(player.field_70702_br, 0.0f, player.field_191988_bg, 0.075f * (player.field_70122_E ? 1.0f : 0.2f));
            } else if (attributeInstance.func_180374_a(SQUID_LAND_SPEED)) {
                input.field_192832_b *= 0.5f;
                input.field_78902_a *= 0.5f;
            }
        }
    }

    @SubscribeEvent
    public void updateFOV(FOVUpdateEvent event) {
        float fov = event.getNewfov();
        if (event.getEntity().func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(IN_USE_SPEED_BOOST)) {
            fov -= 2.0f;
        }
        event.setNewfov(fov);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        int squidPhase = SplatCraftPlayerData.getPlayerData((EntityPlayer)player).isSquid;
        if (squidPhase == 1) {
            event.getRenderer().func_177068_d().func_178633_a(true);
        }
        if (squidPhase != 0) {
            event.setCanceled(true);
            if (!SplatCraftUtils.canSquidHide(player.field_70170_p, player)) {
                if (squidRenderer == null) {
                    squidRenderer = new RenderInklingSquid(event.getRenderer().func_177068_d());
                }
                squidRenderer.doRender(player, event.getX(), event.getY(), event.getZ(), player.field_70759_as, event.getPartialRenderTick());
            } else if (squidPhase == 2) {
                event.getRenderer().func_177068_d().func_178633_a(false);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (Keyboard.getEventKey() == SplatCraftKeyHandler.squidKey.func_151463_i()) {
            if (SplatCraftGamerules.getGameruleValue("tankToTransform") && !(player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemInkTank)) {
                return;
            }
            if (Keyboard.getEventKeyState()) {
                boolean isSquid = SplatCraftPlayerData.getIsSquid((EntityPlayer)player);
                if (SplatCraftConfig.holdKeyToSquid) {
                    isSquid = false;
                } else if (isSquidKeyHeld) {
                    return;
                }
                AxisAlignedBB axisalignedbb = player.func_174813_aQ();
                axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + 0.6, axisalignedbb.field_72338_b + (isSquid ? 1.8 : 0.6), axisalignedbb.field_72339_c + 0.6);
                if (!player.field_70170_p.func_184143_b(axisalignedbb)) {
                    SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketPlayerSetTransformed(player.func_110124_au(), !isSquid));
                    SplatCraftPlayerData.setIsSquid((EntityPlayer)player, !isSquid);
                }
                isSquidKeyHeld = true;
            } else {
                if (!Keyboard.getEventKeyState() && SplatCraftConfig.holdKeyToSquid) {
                    AxisAlignedBB axisalignedbb = player.func_174813_aQ();
                    axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + 0.6, axisalignedbb.field_72338_b + 1.8, axisalignedbb.field_72339_c + 0.6);
                    if (!player.field_70170_p.func_184143_b(axisalignedbb)) {
                        SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketPlayerSetTransformed(player.func_110124_au(), false));
                        SplatCraftPlayerData.setIsSquid((EntityPlayer)player, false);
                    }
                }
                isSquidKeyHeld = false;
            }
        }
    }

    private AttributeModifier getWeaponMod(IAttributeInstance instance) {
        if (instance == null) {
            return null;
        }
        for (ItemWeaponBase item : ItemWeaponBase.weapons) {
            if (item.getSpeedModifier() == null || !instance.func_180374_a(item.getSpeedModifier())) continue;
            return item.getSpeedModifier();
        }
        return null;
    }

    private AttributeModifier getNoInkWeaponMod(IAttributeInstance instance) {
        if (instance == null) {
            return null;
        }
        for (ItemWeaponBase item : ItemWeaponBase.weapons) {
            if (item.getNoInkSpeed() == null || !instance.func_180374_a(item.getNoInkSpeed())) continue;
            return item.getNoInkSpeed();
        }
        return null;
    }
}

