/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.items.IBattleItem;
import com.cibernet.splatcraft.items.ItemDualieBase;
import com.cibernet.splatcraft.items.ItemInkTank;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.network.PacketDodgeRoll;
import com.cibernet.splatcraft.network.PacketGetPlayerData;
import com.cibernet.splatcraft.network.PacketPlayerReturnColor;
import com.cibernet.splatcraft.network.PacketPlayerReturnTransformed;
import com.cibernet.splatcraft.network.PacketUpdateGamerule;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.registries.SplatCraftStats;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonEventHandler {
    public static final CommonEventHandler instance = new CommonEventHandler();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        ItemStack weapon = player.func_184607_cu();
        if (player.field_70170_p.field_72995_K && player.field_70725_aQ == 1) {
            SplatCraftParticleSpawner.spawnSquidSoulParticle(player.field_70165_t, player.field_70163_u, player.field_70161_v, SplatCraftPlayerData.getInkColor(player));
        }
        if (SplatCraftGamerules.getGameruleValue("dealWaterDamage") && player.func_70090_H() && player.field_70173_aa % 10 == 0 && player.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            player.func_70097_a(new DamageSource("water"), 8.0f);
        }
        SplatCraftPlayerData.PlayerData data = SplatCraftPlayerData.getPlayerData(player);
        if (data.isSquid == 1) {
            data.isSquid = 0;
        }
        int inkUnitScore = 0;
        ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestStack.func_77973_b() instanceof ItemInkTank && ColorItemUtils.getInkColor(chestStack) == SplatCraftPlayerData.getInkColor(player)) {
            inkUnitScore = (int)ItemInkTank.getInkAmount(chestStack);
        }
        for (ScoreObjective objective : player.func_96123_co().func_96520_a(SplatcraftScoreboardHandler.INK)) {
            player.func_96123_co().func_96529_a(player.func_70005_c_(), objective).func_96647_c(inkUnitScore);
        }
        if (SplatCraftUtils.onEnemyInk(player.field_70170_p, player) && player.field_70173_aa % 20 == 0 && player.func_110143_aJ() > 4.0f && player.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            player.func_70097_a(new DamageSource("enemyInk"), 1.0f);
        }
        if (SplatCraftPlayerData.getIsSquid(player)) {
            if (!player.func_184218_aH()) {
                SplatCraftUtils.setEntitySize((Entity)player, 0.6f, 0.6f);
                if (!SplatCraft.disableEyeHeight) {
                    player.eyeHeight = 0.4f;
                }
                if (SplatCraftUtils.canSquidHide(player.field_70170_p, player)) {
                    player.field_70143_R = 0.0f;
                    if ((Math.abs(player.field_70165_t - player.field_70169_q) > 0.14 || Math.abs(player.field_70163_u - player.field_70167_r) > 0.14 || Math.abs(player.field_70161_v - player.field_70166_s) > 0.14) && player.field_70170_p.field_72995_K) {
                        SplatCraftParticleSpawner.spawnSquidSwimParticle(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0, SplatCraftPlayerData.getInkColor(player), 4.0f);
                    }
                    if (player.field_70173_aa % 5 == 0) {
                        player.func_70691_i(0.5f);
                    }
                }
                if (player.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c().equals(SplatCraftBlocks.inkwell) && !player.field_70170_p.field_72995_K && player.field_70170_p.func_175625_s(pos.func_177977_b()) instanceof TileEntityColor) {
                    TileEntityColor te = (TileEntityColor)player.field_70170_p.func_175625_s(pos.func_177977_b());
                    if (SplatCraftPlayerData.getInkColor(player) != te.getColor()) {
                        SplatCraftPlayerData.setInkColor(player, te.getColor());
                        SplatCraftPacketHandler.instance.sendToDimension((IMessage)new PacketPlayerReturnColor(player.func_110124_au(), te.getColor()), player.field_71093_bK);
                    }
                }
            }
            SplatCraftPlayerData.dischargeWeapon(player);
            SplatCraftPlayerData.setCanDischarge(player.func_110124_au(), true);
            player.func_71029_a(SplatCraftStats.SQUID_TIME);
        } else if (!player.field_70128_L && !player.func_175149_v()) {
            player.eyeHeight = player.getDefaultEyeHeight();
            if (weapon.func_77973_b() instanceof ItemWeaponBase) {
                ItemWeaponBase item = (ItemWeaponBase)weapon.func_77973_b();
                player.func_70031_b(false);
                boolean canFire = true;
                if (player.func_184600_cs().equals((Object)EnumHand.OFF_HAND) && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemWeaponBase) {
                    canFire = false;
                }
                ItemStack offhandStack = player.func_184586_b(player.func_184614_ca().equals(weapon) ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
                if (item instanceof ItemDualieBase && (!(offhandStack.func_77973_b() instanceof ItemWeaponBase) || offhandStack.func_77973_b() instanceof ItemDualieBase)) {
                    canFire = true;
                }
                if (canFire && player.func_184605_cv() > 0) {
                    item.onItemTickUse(player.field_70170_p, player, weapon, player.func_184605_cv());
                }
                if (item instanceof ItemDualieBase) {
                    ItemDualieBase dualie = (ItemDualieBase)item;
                    int maxRolls = dualie.maxRolls;
                    if (offhandStack.func_77973_b() instanceof ItemDualieBase) {
                        maxRolls += ((ItemDualieBase)offhandStack.func_77973_b()).maxRolls;
                        ((ItemDualieBase)offhandStack.func_77973_b()).onItemTickUse(player.field_70170_p, player, offhandStack, player.func_184605_cv() + ((ItemDualieBase)offhandStack.func_77973_b()).offhandFiringOffset);
                    }
                    int rollCount = ItemDualieBase.getRollString(weapon);
                    CooldownTracker cooldownTracker = player.func_184811_cZ();
                    if (player.field_70170_p.field_72995_K && player instanceof EntityPlayerSP && cooldownTracker.func_185143_a((Item)item, 0.0f) <= 0.0f) {
                        MovementInput input = ((EntityPlayerSP)player).field_71158_b;
                        if (input.field_78901_c && (input.field_78902_a != 0.0f || input.field_192832_b != 0.0f)) {
                            int cooldownB;
                            ItemStack activeDualie = weapon;
                            int cooldownA = dualie.finalRollCooldown;
                            int n = cooldownB = offhandStack.func_77973_b() instanceof ItemDualieBase ? ((ItemDualieBase)offhandStack.func_77973_b()).finalRollCooldown : 0;
                            if (offhandStack.func_77973_b() instanceof ItemDualieBase) {
                                ItemStack dualieA = dualie.maxRolls >= ((ItemDualieBase)offhandStack.func_77973_b()).maxRolls ? weapon : offhandStack;
                                ItemStack dualieB = dualieA.equals(weapon) ? offhandStack : weapon;
                                ItemStack itemStack = activeDualie = maxRolls % 2 == 0 ? dualieA : dualieB;
                            }
                            if (ItemWeaponBase.hasInk(player, weapon, dualie.rollConsumption)) {
                                player.field_70181_x = 0.0;
                                player.func_191958_b(input.field_78902_a, -0.2f, input.field_192832_b, ((ItemDualieBase)activeDualie.func_77973_b()).rollSpeed);
                                dualie = (ItemDualieBase)activeDualie.func_77973_b();
                                int cooldown = rollCount >= maxRolls - 1 ? Math.max(cooldownA, cooldownB) : dualie.rollCooldown;
                                SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketDodgeRoll(activeDualie.equals(offhandStack), cooldown));
                                cooldownTracker.func_185145_a(weapon.func_77973_b(), cooldown);
                                if (offhandStack.func_77973_b() instanceof ItemDualieBase) {
                                    cooldownTracker.func_185145_a(offhandStack.func_77973_b(), cooldown);
                                }
                                ItemDualieBase.setRollString(weapon, rollCount + 1);
                                ItemDualieBase.setRollCooldown(weapon, (int)((double)dualie.finalRollCooldown * 0.75));
                                ItemWeaponBase.reduceInk(player, ((ItemDualieBase)activeDualie.func_77973_b()).rollConsumption);
                            } else {
                                player.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                            }
                        }
                    }
                }
            } else if (SplatCraftPlayerData.canDischarge(player)) {
                SplatCraftPlayerData.dischargeWeapon(player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEntity(AttackEntityEvent event) {
        if (event.getEntityPlayer().func_184614_ca().func_77973_b() instanceof ItemWeaponBase && ((ItemWeaponBase)((EntityLivingBase)event.getEntity()).func_184614_ca().func_77973_b()).onItemLeftClick(event.getEntityPlayer().func_130014_f_(), event.getEntityPlayer(), event.getEntityPlayer().func_184614_ca())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerVisibility(PlayerEvent.Visibility event) {
        EntityPlayer player = event.getEntityPlayer();
        if (SplatCraftPlayerData.getIsSquid(player) && SplatCraftUtils.canSquidHide(player.field_70170_p, player)) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<Entity> entityItems = new ArrayList<Entity>(event.world.field_72996_f);
            entityItems.removeIf(entity -> !(entity instanceof EntityItem));
            for (Entity entity2 : entityItems) {
                EntityItem entityItem = (EntityItem)entity2;
                BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u - 1.0, entityItem.field_70161_v);
                ItemStack stack = entityItem.func_92059_d();
                if ((stack.func_77973_b().equals(Item.func_150898_a((Block)SplatCraftBlocks.inkedWool)) || stack.func_77969_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 0))) && entityItem.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell)) {
                    if (!(entityItem.field_70170_p.func_175625_s(pos) instanceof TileEntityColor)) continue;
                    TileEntityColor te = (TileEntityColor)entityItem.field_70170_p.func_175625_s(pos);
                    stack = new ItemStack(SplatCraftBlocks.inkedWool, stack.func_190916_E());
                    entityItem.func_92058_a(stack);
                    ColorItemUtils.setInkColor(stack, te.getColor());
                    continue;
                }
                if (!stack.func_77973_b().equals(Item.func_150898_a((Block)SplatCraftBlocks.inkedWool)) || !entityItem.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a().equals(Material.field_151586_h)) continue;
                entityItem.func_92058_a(new ItemStack(Blocks.field_150325_L, stack.func_190916_E()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        if (stack.func_77973_b() instanceof ItemInkTank) {
            ItemInkTank.setInkAmount(stack, ((ItemInkTank)stack.func_77973_b()).capacity);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeathDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && !(player instanceof FakePlayer) && !event.isCanceled() && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && SplatCraftGamerules.getGameruleValue("keepWeaponsOnDeath")) {
            ListIterator iter = event.getDrops().listIterator();
            int i = 0;
            while (iter.hasNext()) {
                EntityItem ei = (EntityItem)iter.next();
                ItemStack item = ei.func_92059_d();
                if (item.func_77973_b() instanceof IBattleItem && CommonEventHandler.addToPlayerInventory(player, item)) {
                    iter.remove();
                }
                ++i;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer originalPlayer;
        if (!(!event.isWasDeath() || event.isCanceled() || (originalPlayer = event.getOriginal()) == null || event.getEntityPlayer() == null || event.getEntityPlayer() instanceof FakePlayer || event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory") || !SplatCraftGamerules.getGameruleValue("keepWeaponsOnDeath") || originalPlayer == event.getEntityPlayer() || originalPlayer.field_71071_by == event.getEntityPlayer().field_71071_by || originalPlayer.field_71071_by.field_70460_b == event.getEntityPlayer().field_71071_by.field_70460_b && originalPlayer.field_71071_by.field_70462_a == event.getEntityPlayer().field_71071_by.field_70462_a)) {
            ItemStack item;
            int i;
            for (i = 0; i < originalPlayer.field_71071_by.field_70460_b.size(); ++i) {
                item = (ItemStack)originalPlayer.field_71071_by.field_70460_b.get(i);
                if (!(item.func_77973_b() instanceof IBattleItem) || !CommonEventHandler.addToPlayerInventory(event.getEntityPlayer(), item)) continue;
                originalPlayer.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
            }
            for (i = 0; i < originalPlayer.field_71071_by.field_70462_a.size(); ++i) {
                item = (ItemStack)originalPlayer.field_71071_by.field_70462_a.get(i);
                if (!(item.func_77973_b() instanceof IBattleItem) || !CommonEventHandler.addToPlayerInventory(event.getEntityPlayer(), item)) continue;
                originalPlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        SplatCraftPlayerData.PlayerData data = SplatCraftPlayerData.getPlayerData(player.func_110124_au());
        if (!event.getWorld().field_72995_K) {
            SplatCraftPacketHandler.instance.sendToDimension((IMessage)new PacketPlayerReturnColor(player.func_110124_au(), data.inkColor), player.field_71093_bK);
            SplatCraftPacketHandler.instance.sendToDimension((IMessage)new PacketPlayerReturnTransformed(player.func_110124_au(), data.isSquid == 2), player.field_71093_bK);
            NBTTagCompound ruleNBT = new NBTTagCompound();
            SplatCraftGamerules.writeToNBT(ruleNBT);
            SplatCraftPacketHandler.instance.sendTo((IMessage)new PacketUpdateGamerule(ruleNBT), (EntityPlayerMP)player);
        } else {
            SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketGetPlayerData());
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (SplatCraftPlayerData.getIsSquid(event.getEntityPlayer()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (SplatCraftPlayerData.getIsSquid(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (name.equals((Object)LootTableList.field_186390_ao)) {
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("splatcraft", "inject/fishing_fish"), 5, 2, new LootCondition[0], "splatcraft:fishing_fish");
            LootPool main = event.getTable().getPool("main");
            if (main != null) {
                main.addEntry((LootEntry)entry);
            } else {
                SplatCraft.logger.info("The main fish loot pool is null, probably due to another mod, so you won't be able to get power eggs from fishing");
            }
        } else if (name.equals((Object)LootTableList.field_186389_an)) {
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("splatcraft", "inject/fishing_treasure"), 2, 5, new LootCondition[0], "splatcraft:fishing_treasure");
            LootPool main = event.getTable().getPool("main");
            if (main != null) {
                main.addEntry((LootEntry)entry);
            } else {
                SplatCraft.logger.info("The main fishing treasure loot pool is null, probably due to another mod, so you won't be able to get sunken crates from fishing");
            }
        }
    }

    private AttributeModifier getWeaponMod(IAttributeInstance instance) {
        for (ItemWeaponBase item : ItemWeaponBase.weapons) {
            if (item.getSpeedModifier() == null || !instance.func_180374_a(item.getSpeedModifier())) continue;
            return item.getSpeedModifier();
        }
        return null;
    }

    private static boolean addToPlayerInventory(EntityPlayer player, ItemStack stack, int slot) {
        if (!player.field_71071_by.func_70301_a(slot).func_190926_b()) {
            return CommonEventHandler.addToPlayerInventory(player, stack);
        }
        player.field_71071_by.func_70299_a(slot, stack);
        return true;
    }

    private static boolean addArmorToPlayerInventory(EntityPlayer player, ItemStack stack, int slot) {
        if (!player.field_71071_by.func_70440_f(slot).func_190926_b()) {
            return CommonEventHandler.addToPlayerInventory(player, stack);
        }
        player.field_71071_by.field_70460_b.set(slot, (Object)stack);
        return true;
    }

    private static boolean addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item != null && entityPlayer != null) {
            int i;
            if (item.func_77973_b() instanceof ItemArmor) {
                ItemArmor arm = (ItemArmor)item.func_77973_b();
                i = arm.field_77881_a.func_188454_b();
                if (((ItemStack)entityPlayer.field_71071_by.field_70460_b.get(i)).func_190926_b()) {
                    entityPlayer.field_71071_by.field_70460_b.set(i, (Object)item);
                    return true;
                }
            }
            InventoryPlayer inv = entityPlayer.field_71071_by;
            for (i = 0; i < inv.field_70462_a.size(); ++i) {
                if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
                inv.field_70462_a.set(i, (Object)item.func_77946_l());
                return true;
            }
            return false;
        }
        return false;
    }
}

