/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityBlasterProjectile;
import com.cibernet.splatcraft.items.ItemShooterBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemBlasterBase
extends ItemShooterBase {
    public int projLifespan;
    public int startupTicks;
    public int cooldown;
    public float splashDamage;

    public ItemBlasterBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, float inaccuracy, int startupTicks, int cooldown, float damage, float splashDamage, float inkConsumption, int projectileLifespan) {
        super(unlocName, registryName, projectileSize, projectileSpeed, inaccuracy, cooldown, damage, inkConsumption, true);
        this.projLifespan = projectileLifespan;
        this.startupTicks = startupTicks;
        this.cooldown = cooldown;
        this.splashDamage = splashDamage;
    }

    public ItemBlasterBase(String unlocName, String registryName, ItemBlasterBase parent) {
        this(unlocName, registryName, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.startupTicks, parent.cooldown, parent.damage, parent.splashDamage, parent.inkConsumption, parent.projLifespan);
    }

    public ItemBlasterBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemBlasterBase)parent);
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        if (this.hasInk(playerIn, stack)) {
            CooldownTracker cooldownTracker = playerIn.func_184811_cZ();
            if (!worldIn.field_72995_K && !cooldownTracker.func_185141_a((Item)this)) {
                if (this.func_77626_a(stack) - useTime < this.startupTicks) {
                    cooldownTracker.func_185145_a((Item)this, this.startupTicks);
                } else {
                    this.reduceInk(playerIn);
                    EntityBlasterProjectile proj = new EntityBlasterProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.damage, this.splashDamage, this.projLifespan);
                    proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.projectileSpeed, this.inaccuracy);
                    proj.setProjectileSize(this.projectileSize);
                    worldIn.func_72838_d((Entity)proj);
                    cooldownTracker.func_185145_a((Item)this, this.cooldown);
                }
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
    }
}

