/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityChargerProjectile;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.ICharge;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.network.PacketReturnChargeRelease;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemChargerBase
extends ItemWeaponBase
implements ICharge {
    private final AttributeModifier SPEED_MODIFIER;
    public float projectileSize;
    public float projectileSpeed;
    public int projectileLifespan;
    public float chargeSpeed;
    public float dischargeSpeed;
    public float damage;
    public float minConsumption;
    public float maxConsumption;
    private final double mobility;

    public ItemChargerBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, int projectileLifespan, int chargeTime, int dischargeTime, float damage, float minConsumption, float maxConsumption, double mobility) {
        super(unlocName, registryName, maxConsumption);
        this.projectileSize = projectileSize;
        this.projectileLifespan = projectileLifespan;
        this.chargeSpeed = 1.0f / (float)chargeTime;
        this.dischargeSpeed = 1.0f / (float)dischargeTime;
        this.damage = damage;
        this.projectileSpeed = projectileSpeed;
        this.mobility = mobility;
        this.SPEED_MODIFIER = new AttributeModifier("Charger Mobility", mobility - 1.0, 2).func_111168_a(false);
        this.maxConsumption = maxConsumption;
        this.minConsumption = minConsumption;
    }

    public ItemChargerBase(String unlocName, String registryName, ItemChargerBase parent) {
        this(unlocName, registryName, parent.projectileSize, parent.projectileSpeed, parent.projectileLifespan, (int)(1.0f / parent.chargeSpeed), (int)(1.0f / parent.dischargeSpeed), parent.damage, parent.minConsumption, parent.maxConsumption, parent.mobility);
    }

    public ItemChargerBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemChargerBase)parent);
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityIn;
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        if (!SplatCraftPlayerData.getIsSquid(playerIn)) {
            if (ItemChargerBase.hasInk(playerIn, stack, this.getInkConsumption(SplatCraftPlayerData.getWeaponCharge(playerIn, stack)))) {
                SplatCraftPlayerData.addWeaponCharge(playerIn, stack, this.chargeSpeed);
            } else {
                playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
            }
        }
    }

    @Override
    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (worldIn.field_72995_K && !SplatCraftPlayerData.getIsSquid((EntityPlayer)entityLiving)) {
            UUID player = entityLiving.func_110124_au();
            float charge = SplatCraftPlayerData.getWeaponCharge(player, stack);
            if (charge > 0.05f) {
                SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketReturnChargeRelease(charge, stack));
                SplatCraftPlayerData.setWeaponCharge(player, stack, 0.0f);
            }
            SplatCraftPlayerData.setCanDischarge(player, true);
        }
    }

    @Override
    public float getDischargeSpeed() {
        return this.dischargeSpeed;
    }

    @Override
    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    @Override
    public void onRelease(World worldIn, EntityPlayer playerIn, ItemStack stack) {
        float charge = SplatCraftPlayerData.getWeaponCharge(playerIn, stack);
        EntityChargerProjectile proj = new EntityChargerProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), charge > 0.95f ? this.damage : this.damage * charge / 4.0f + this.damage / 4.0f, (int)((float)this.projectileLifespan * charge));
        proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.projectileSpeed, 0.1f);
        proj.setProjectileSize(this.projectileSize);
        worldIn.func_72838_d((Entity)proj);
        SplatCraftPlayerData.setWeaponCharge(playerIn, stack, 0.0f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
    }

    @Override
    public AttributeModifier getSpeedModifier() {
        return this.SPEED_MODIFIER;
    }

    @Override
    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.CHARGER;
    }

    public float getInkConsumption(float charge) {
        return this.minConsumption + (this.maxConsumption - this.minConsumption) * charge;
    }
}

