/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.items.ItemRemote;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemColorChanger
extends ItemRemote {
    public ItemColorChanger() {
        this.func_77655_b("colorChanger");
        this.setRegistryName("color_changer");
        this.func_77625_d(1);
        this.func_77637_a(TabSplatCraft.main);
        ColorItemUtils.inkColorItems.add(this);
        this.totalModes = 3;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ColorItemUtils.isColorLocked(stack)) {
            int color = ColorItemUtils.getInkColor(stack);
            tooltip.add(SplatCraftUtils.getColorName(color));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ColorItemUtils.isColorLocked(stack) || !(entityIn instanceof EntityPlayer)) {
            return;
        }
        ColorItemUtils.setInkColor(stack, SplatCraftPlayerData.getInkColor((EntityPlayer)entityIn));
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u - 1.0, entityItem.field_70161_v);
        ItemStack stack = entityItem.func_92059_d();
        if (entityItem.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell)) {
            if (entityItem.field_70170_p.func_175625_s(pos) instanceof TileEntityColor) {
                TileEntityColor te = (TileEntityColor)entityItem.field_70170_p.func_175625_s(pos);
                if (ColorItemUtils.getInkColor(stack) != te.getColor() || !ColorItemUtils.isColorLocked(stack)) {
                    ColorItemUtils.setInkColor(stack, te.getColor());
                    ColorItemUtils.setColorLocked(stack, true);
                }
            }
        } else if (entityItem.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a().equals(Material.field_151586_h) && ColorItemUtils.isColorLocked(stack)) {
            ColorItemUtils.setInkColor(stack, InkColors.DYE_WHITE.getColor());
            ColorItemUtils.setColorLocked(stack, false);
        }
        return super.onEntityItemUpdate(entityItem);
    }

    @Override
    public ItemRemote.RemoteResult onRemoteUse(World world, BlockPos blockpos, BlockPos blockpos1, ItemStack stack, int colorIn, int mode) {
        BlockPos blockpos2 = new BlockPos(Math.min(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.min(blockpos.func_177956_o(), Math.min(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.min(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        BlockPos blockpos3 = new BlockPos(Math.max(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.max(blockpos.func_177956_o(), Math.max(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.max(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        if (blockpos2.func_177956_o() < 0 || blockpos3.func_177956_o() >= 256) {
            return ItemColorChanger.createResult(false, (TextComponentBase)new TextComponentTranslation("commands.clearInk.outOfWorld", new Object[0]));
        }
        for (int j = blockpos2.func_177952_p(); j <= blockpos3.func_177952_p(); j += 16) {
            for (int k = blockpos2.func_177958_n(); k <= blockpos3.func_177958_n(); k += 16) {
                if (world.func_175667_e(new BlockPos(k, blockpos3.func_177956_o() - blockpos2.func_177956_o(), j))) continue;
                return ItemColorChanger.createResult(false, (TextComponentBase)new TextComponentTranslation("commands.clearInk.outOfWorld", new Object[0]));
            }
        }
        int count = 0;
        int color = ColorItemUtils.getInkColor(stack);
        for (int x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
            for (int y = blockpos2.func_177956_o(); y <= blockpos3.func_177956_o(); ++y) {
                for (int z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (!(block instanceof IInked)) continue;
                    TileEntityColor te = (TileEntityColor)world.func_175625_s(pos);
                    if (((IInked)block).countsTowardsScore() || te.getColor() == color || mode != 0 && (mode != 1 || te.getColor() != colorIn) && (mode != 2 || te.getColor() == colorIn) || te.getColor() == color) continue;
                    te.setColor(color);
                    world.func_184138_a(pos, state, state, 3);
                    ++count;
                }
            }
        }
        return ItemColorChanger.createResult(true, (TextComponentBase)new TextComponentTranslation("commands.changeColor.success", new Object[]{count, SplatCraftUtils.getColorName(color)}));
    }
}

