/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDualieBase
extends ItemWeaponBase {
    public float projectileSize;
    public float inaccuracy;
    public float projectileSpeed;
    public int firingSpeed;
    public float damage;
    public int maxRolls;
    public float rollSpeed;
    public float rollConsumption;
    public int rollCooldown;
    public int finalRollCooldown;
    public int offhandFiringOffset;

    public ItemDualieBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConsumption, int rolls, float rollSpeed, float rollConsuption, int rollCooldown, int finalRollCooldown) {
        super(unlocName, registryName, inkConsumption);
        this.inaccuracy = inaccuracy;
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.firingSpeed = firingSpeed;
        this.damage = damage;
        this.maxRolls = rolls;
        this.rollSpeed = rollSpeed;
        this.rollConsumption = rollConsuption;
        this.offhandFiringOffset = firingSpeed / 2;
        this.rollCooldown = rollCooldown;
        this.finalRollCooldown = finalRollCooldown;
        this.func_185043_a(new ResourceLocation("isLeft"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null || entityIn.func_184591_cq() == null) {
                    return 0.0f;
                }
                boolean mainLeft = entityIn.func_184591_cq().equals((Object)EnumHandSide.LEFT);
                return mainLeft && entityIn.func_184614_ca().equals(stack) || !mainLeft && entityIn.func_184592_cb().equals(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public ItemDualieBase(String unlocName, String registryName, ItemDualieBase parent) {
        this(unlocName, registryName, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.firingSpeed, parent.damage, parent.inkConsumption, parent.maxRolls, parent.rollSpeed, parent.rollConsumption, parent.rollCooldown, parent.finalRollCooldown);
    }

    public ItemDualieBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemDualieBase)parent);
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        int actualUseTime = this.func_77626_a(stack) - useTime;
        int startupLag = 2;
        if (this.hasInk(playerIn, stack)) {
            if (actualUseTime > startupLag && (actualUseTime - startupLag) % this.firingSpeed == 1 && !worldIn.field_72995_K) {
                this.reduceInk(playerIn);
                EntityInkProjectile proj = new EntityInkProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.damage);
                proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.projectileSpeed, playerIn.func_184811_cZ().func_185143_a(stack.func_77973_b(), 0.0f) > 0.0f ? 0.0f : this.inaccuracy);
                proj.setProjectileSize(this.projectileSize);
                worldIn.func_72838_d((Entity)proj);
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
    }

    @Override
    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.DUALIES;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        int rollCooldown = ItemDualieBase.getRollCooldown(stack);
        if (rollCooldown > 0) {
            ItemDualieBase.setRollCooldown(stack, rollCooldown - 1);
        } else if (ItemDualieBase.getRollString(stack) > 0) {
            ItemDualieBase.setRollString(stack, 0);
        }
    }

    public static int getRollString(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("rollString")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("rollString");
    }

    public static ItemStack setRollString(ItemStack stack, int rollString) {
        ColorItemUtils.checkTagCompound(stack).func_74768_a("rollString", rollString);
        return stack;
    }

    public static int getRollCooldown(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("rollCooldown")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("rollCooldown");
    }

    public static ItemStack setRollCooldown(ItemStack stack, int rollCooldown) {
        ColorItemUtils.checkTagCompound(stack).func_74768_a("rollCooldown", rollCooldown);
        return stack;
    }
}

