/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.items.IBattleItem;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemInkColoredArmor
extends ItemArmor
implements IBattleItem {
    public ItemInkColoredArmor(String unlocName, String registryName, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(unlocName);
        this.setRegistryName(registryName);
        this.func_77637_a(TabSplatCraft.main);
        ColorItemUtils.inkColorItems.add((Item)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ColorItemUtils.isColorLocked(stack)) {
            int color = ColorItemUtils.getInkColor(stack);
            tooltip.add(SplatCraftUtils.getColorName(color));
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.inkCloth.tooltip", (Object[])new Object[0]));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ColorItemUtils.isColorLocked(stack) || !(entityIn instanceof EntityPlayer)) {
            return;
        }
        ColorItemUtils.setInkColor(stack, SplatCraftPlayerData.getInkColor((EntityPlayer)entityIn));
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u - 1.0, entityItem.field_70161_v);
        ItemStack stack = entityItem.func_92059_d();
        if (entityItem.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell)) {
            if (entityItem.field_70170_p.func_175625_s(pos) instanceof TileEntityColor) {
                TileEntityColor te = (TileEntityColor)entityItem.field_70170_p.func_175625_s(pos);
                if (ColorItemUtils.getInkColor(stack) != te.getColor() || !ColorItemUtils.isColorLocked(stack)) {
                    ColorItemUtils.setInkColor(stack, te.getColor());
                    ColorItemUtils.setColorLocked(stack, true);
                }
            }
        } else if (entityItem.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a().equals(Material.field_151586_h) && ColorItemUtils.isColorLocked(stack)) {
            ColorItemUtils.setInkColor(stack, InkColors.DYE_WHITE.getColor());
            ColorItemUtils.setColorLocked(stack, false);
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        return ColorItemUtils.getInkColor(stack);
    }
}

