/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.models.ModelAbstractTank;
import com.cibernet.splatcraft.items.IBattleItem;
import com.cibernet.splatcraft.items.ICharge;
import com.cibernet.splatcraft.items.ItemInkColoredArmor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInkTank
extends ItemInkColoredArmor
implements IBattleItem {
    private final List<Item> weaponWhitelist = new ArrayList<Item>();
    private final List<Item> weaponBlacklist = new ArrayList<Item>();
    public final float capacity;
    public final ItemArmor.ArmorMaterial field_77878_bZ;
    @SideOnly(value=Side.CLIENT)
    private ModelAbstractTank model;

    public ItemInkTank(String unlocalizedName, String registryName, final float capacity, ItemArmor.ArmorMaterial materialIn) {
        super(unlocalizedName, registryName, materialIn, 0, EntityEquipmentSlot.CHEST);
        this.capacity = capacity;
        this.field_77878_bZ = materialIn;
        this.func_185043_a(new ResourceLocation("ink_stage"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                float pctg = ItemInkTank.getInkAmount(stack) / capacity;
                return pctg > 0.6f ? 2.0f : (pctg <= 0.3f ? 0.0f : 1.0f);
            }
        });
    }

    public ItemInkTank(String unlocalizedName, String registryName, float capacity, int armorPoints) {
        this(unlocalizedName, registryName, capacity, EnumHelper.addArmorMaterial((String)unlocalizedName, (String)("splatcraft:" + registryName), (int)-1, (int[])new int[]{armorPoints, armorPoints, armorPoints, armorPoints}, (int)0, (SoundEvent)SoundEvents.field_187713_n, (float)0.0f));
    }

    public ItemInkTank(String unlocalizedName, String registryName, float capacity) {
        this(unlocalizedName, registryName, capacity, 0);
    }

    public ItemInkTank(String unlocalizedName, String registryName, ItemInkTank parent) {
        this(unlocalizedName, registryName, parent.capacity, EnumHelper.addArmorMaterial((String)unlocalizedName, (String)("splatcraft:" + registryName), (int)-1, (int[])new int[]{parent.field_77878_bZ.func_78044_b(EntityEquipmentSlot.FEET), parent.field_77878_bZ.func_78044_b(EntityEquipmentSlot.LEGS), parent.field_77878_bZ.func_78044_b(EntityEquipmentSlot.CHEST), parent.field_77878_bZ.func_78044_b(EntityEquipmentSlot.HEAD)}, (int)0, (SoundEvent)SoundEvents.field_187713_n, (float)0.0f));
        this.weaponBlacklist.addAll(parent.weaponBlacklist);
        this.weaponWhitelist.addAll(parent.weaponWhitelist);
    }

    public ItemInkTank(String unlocalizedName, String registryName, Item parent) {
        this(unlocalizedName, registryName, (ItemInkTank)parent);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        String desc = I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]);
        if (!desc.equals(this.func_77658_a() + ".tooltip")) {
            tooltip.add(desc);
        }
        if (advanced.func_194127_a()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.inkTank.ink", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ItemInkTank.getInkAmount(stack))), Float.valueOf(this.capacity)}));
        }
        if (ColorItemUtils.isColorLocked(stack)) {
            int color = ColorItemUtils.getInkColor(stack);
            tooltip.add(SplatCraftUtils.getColorName(color));
        }
    }

    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped _default) {
        if (entity.func_130014_f_().field_72995_K) {
            ModelBiped model = this.getInkTankModel(entity, stack, slot, _default);
            return model != null ? model : super.getArmorModel(entity, stack, slot, _default);
        }
        return super.getArmorModel(entity, stack, slot, _default);
    }

    @SideOnly(value=Side.CLIENT)
    private ModelBiped getInkTankModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped _default) {
        if (!(stack.func_77973_b() instanceof ItemInkTank)) {
            return super.getArmorModel(entity, stack, slot, _default);
        }
        if (this.model == null) {
            return super.getArmorModel(entity, stack, slot, _default);
        }
        this.model.setInk(ItemInkTank.getInkAmount(stack) / ((ItemInkTank)stack.func_77973_b()).capacity);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemInkTank) {
            this.model.field_178721_j.field_78806_j = slot == EntityEquipmentSlot.LEGS || slot == EntityEquipmentSlot.FEET;
            this.model.field_178722_k.field_78806_j = slot == EntityEquipmentSlot.LEGS || slot == EntityEquipmentSlot.FEET;
            this.model.field_78115_e.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            this.model.field_178724_i.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            this.model.field_78116_c.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            this.model.field_78117_n = _default.field_78117_n;
            this.model.field_78093_q = _default.field_78093_q;
            this.model.field_78091_s = _default.field_78091_s;
            this.model.field_187076_m = _default.field_187076_m;
            this.model.field_187075_l = _default.field_187075_l;
            return this.model;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Item setArmorModel(ModelAbstractTank model) {
        this.model = model;
        return this;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        float ink = ItemInkTank.getInkAmount(stack);
        if (player.func_184582_a(EntityEquipmentSlot.CHEST).equals(stack) && SplatCraftPlayerData.getInkColor(player) == ColorItemUtils.getInkColor(stack) && ink < this.capacity && (player.func_184607_cu().func_190926_b() || player.func_184607_cu().func_77973_b() instanceof ICharge)) {
            float rechargeAmnt = SplatCraftPlayerData.getIsSquid(player) && SplatCraftUtils.canSquidHide(worldIn, player) ? 1.0f : 0.1f;
            ItemInkTank.setInkAmount(stack, Math.min(this.capacity, ink + rechargeAmnt));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - ItemInkTank.getInkAmount(stack) / this.capacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorItemUtils.getInkColor(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("ink") && ItemInkTank.getInkAmount(stack) < this.capacity;
    }

    public boolean isRepairable() {
        return false;
    }

    public static float getInkAmount(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("ink")) {
            return 0.0f;
        }
        return stack.func_77978_p().func_74760_g("ink");
    }

    public static float getInkAmountStatic(ItemStack stack, ItemStack weapon) {
        if (stack.func_77973_b() instanceof ItemInkTank) {
            return ((ItemInkTank)stack.func_77973_b()).getInkAmount(stack, weapon);
        }
        return ItemInkTank.getInkAmount(stack);
    }

    public float getInkAmount(ItemStack stack, ItemStack weapon) {
        if ((this.weaponWhitelist.isEmpty() || this.weaponWhitelist.contains(weapon.func_77973_b())) && !this.weaponBlacklist.contains(weapon)) {
            return ItemInkTank.getInkAmount(stack);
        }
        return 0.0f;
    }

    public static ItemStack setInkAmount(ItemStack stack, float ink) {
        ColorItemUtils.checkTagCompound(stack).func_74776_a("ink", ink);
        return stack;
    }

    public ItemInkTank addAllowedWeapons(Item ... weapons) {
        this.weaponWhitelist.addAll(Arrays.asList(weapons));
        return this;
    }

    public ItemInkTank addUnallowedWeapons(Item ... weapons) {
        this.weaponBlacklist.addAll(Arrays.asList(weapons));
        return this;
    }
}

