/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemote
extends Item {
    protected int totalModes = 1;

    public ItemRemote() {
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemRemote.hasCoordSet(stack) ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemRemote.getRemoteMode(stack);
            }
        });
    }

    protected static NBTTagCompound checkTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        if (ItemRemote.hasCoordSet(stack)) {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"item.coordSet.tooltip.b", (Object[])new Object[]{compound.func_74762_e("pointAX"), compound.func_74762_e("pointAY"), compound.func_74762_e("pointAZ"), compound.func_74762_e("pointBX"), compound.func_74762_e("pointBY"), compound.func_74762_e("pointBZ")}));
        } else if (compound.func_74764_b("pointAX") && compound.func_74764_b("pointAY") && compound.func_74764_b("pointAZ")) {
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"item.coordSet.tooltip.a", (Object[])new Object[]{compound.func_74762_e("pointAX"), compound.func_74762_e("pointAY"), compound.func_74762_e("pointAZ")}));
        }
    }

    public static boolean hasCoordSet(ItemStack stack) {
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        return compound.func_74764_b("pointAX") && compound.func_74764_b("pointAY") && compound.func_74764_b("pointAZ") && compound.func_74764_b("pointBX") && compound.func_74764_b("pointBY") && compound.func_74764_b("pointBZ");
    }

    public static BlockPos[] getCoordSet(ItemStack stack) {
        if (!ItemRemote.hasCoordSet(stack)) {
            return new BlockPos[0];
        }
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        return new BlockPos[]{new BlockPos(compound.func_74762_e("pointAX"), compound.func_74762_e("pointAY"), compound.func_74762_e("pointAZ")), new BlockPos(compound.func_74762_e("pointBX"), compound.func_74762_e("pointBY"), compound.func_74762_e("pointBZ"))};
    }

    public static boolean addCoords(EntityPlayer playerIn, ItemStack stack, BlockPos pos) {
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        if (compound.func_74764_b("pointBX") && compound.func_74764_b("pointBY") && compound.func_74764_b("pointBZ")) {
            return false;
        }
        String key = compound.func_74764_b("pointAX") && compound.func_74764_b("pointAY") && compound.func_74764_b("pointAZ") ? "B" : "A";
        compound.func_74768_a("point" + key + "X", pos.func_177958_n());
        compound.func_74768_a("point" + key + "Y", pos.func_177956_o());
        compound.func_74768_a("point" + key + "Z", pos.func_177952_p());
        if (playerIn.field_70170_p.field_72995_K) {
            playerIn.func_146105_b((ITextComponent)new TextComponentString(net.minecraft.client.resources.I18n.func_135052_a((String)("status.coordSet." + key), (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})), true);
        }
        return true;
    }

    public static int getRemoteMode(ItemStack stack) {
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        return compound.func_74762_e("mode");
    }

    public static void setRemoteMode(ItemStack stack, int mode) {
        NBTTagCompound compound = ItemRemote.checkTagCompound(stack);
        compound.func_74768_a("mode", mode);
    }

    public static int cycleRemoteMode(ItemStack stack) {
        int mode = ItemRemote.getRemoteMode(stack) + 1;
        if (stack.func_77973_b() instanceof ItemRemote) {
            mode %= ((ItemRemote)stack.func_77973_b()).totalModes;
        }
        ItemRemote.setRemoteMode(stack, mode);
        return mode;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemRemote.addCoords(player, player.func_184586_b(hand), pos) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int mode = ItemRemote.getRemoteMode(stack);
        if (playerIn.func_70093_af()) {
            if (this.totalModes > 1) {
                mode = ItemRemote.cycleRemoteMode(stack);
                String unformatedMode = this.func_77658_a() + ".mode." + mode;
                String modeName = I18n.func_74838_a((String)unformatedMode);
                if (modeName.equals(unformatedMode)) {
                    modeName = mode + "";
                }
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("status.remoteMode", new Object[]{modeName}), true);
            }
        } else if (ItemRemote.hasCoordSet(stack)) {
            RemoteResult result = this.onRemoteUse(worldIn, stack, SplatCraftPlayerData.getInkColor(playerIn), mode);
            if (result.getOutput() != null) {
                playerIn.func_146105_b((ITextComponent)result.getOutput(), true);
            }
            return new ActionResult(result.wasSuccessful() ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public RemoteResult onRemoteUse(World world, BlockPos posA, BlockPos posB, @Nullable ItemStack stack, int colorIn, int mode) {
        return ItemRemote.createResult(false, null);
    }

    public RemoteResult onRemoteUse(World world, ItemStack stack, int colorIn, int mode) {
        BlockPos[] coordSet = ItemRemote.getCoordSet(stack);
        BlockPos blockpos = coordSet[0];
        BlockPos blockpos1 = coordSet[1];
        return this.onRemoteUse(world, blockpos, blockpos1, stack, colorIn, mode);
    }

    public static RemoteResult createResult(boolean success, TextComponentBase output) {
        return new RemoteResult(success, output);
    }

    public static class RemoteResult {
        boolean success;
        TextComponentBase output;

        public RemoteResult(boolean success, TextComponentBase output) {
            this.success = success;
            this.output = output;
        }

        public boolean wasSuccessful() {
            return this.success;
        }

        public TextComponentBase getOutput() {
            return this.output;
        }
    }
}

