/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.entities.classes.EntitySquidBumper;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRollerBase
extends ItemWeaponBase {
    private final AttributeModifier SPEED_MODIFIER;
    private final AttributeModifier NO_INK_SPEED_MODIFIER;
    protected double weaponSpeed;
    protected float flingSpeed;
    protected boolean isBrush;
    protected int rollRadius;
    protected float flingSize;
    protected float rollDamage;
    protected float flingDamage;
    protected float flingConsumption;
    private double rollSpeed;

    public ItemRollerBase(String unlocName, String registryName, double weaponSpeed, float flingSpeed, float flingDamage, float flingSize, float flingConsumption, double rollSpeed, int rollRadius, float rollDamage, float inkConsumption, boolean isBrush) {
        super(unlocName, registryName, inkConsumption);
        this.weaponSpeed = weaponSpeed;
        this.flingSpeed = flingSpeed;
        this.rollRadius = rollRadius;
        this.flingSize = flingSize;
        this.rollDamage = rollDamage;
        this.flingDamage = flingDamage;
        this.flingConsumption = flingConsumption;
        this.isBrush = isBrush;
        this.rollSpeed = rollSpeed;
        this.SPEED_MODIFIER = new AttributeModifier("Rolling speed boost", rollSpeed - 1.0, 2).func_111168_a(false);
        this.NO_INK_SPEED_MODIFIER = new AttributeModifier("Rolling speed boost", -(rollSpeed - 1.0) * 2.0, 2).func_111168_a(false);
        this.func_185043_a(new ResourceLocation("unfolded"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemRollerBase(String unlocName, String registryName, ItemRollerBase parent) {
        this(unlocName, registryName, parent.weaponSpeed, parent.flingSpeed, parent.flingDamage, parent.flingSize, parent.flingConsumption, parent.rollSpeed, parent.rollRadius, parent.rollDamage, parent.inkConsumption, parent.isBrush);
    }

    public ItemRollerBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemRollerBase)parent);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af() || playerIn.func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getWeaponSpeed(stack), 0));
        }
        return multimap;
    }

    public double getWeaponSpeed(ItemStack stack) {
        return this.weaponSpeed;
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        int actualUseTime = this.func_77626_a(stack) - useTime;
        if (actualUseTime <= 1) {
            playerIn.func_184821_cY();
        }
        boolean glowingInk = SplatCraftUtils.getPlayerGlowingInk(playerIn);
        if (this.hasInk(playerIn, stack)) {
            this.reduceInk(playerIn);
            int color = ColorItemUtils.getInkColor(stack);
            int downReach = playerIn.field_70163_u % 1.0 < 0.5 ? 1 : 0;
            Vec3d fwd = this.getFwd(0.0f, playerIn.field_70177_z).func_72432_b();
            fwd = new Vec3d((double)Math.round(fwd.field_72450_a), (double)Math.round(fwd.field_72448_b), (double)Math.round(fwd.field_72449_c));
            BlockPos pos = new BlockPos(Math.floor(playerIn.field_70165_t) + 0.5, playerIn.field_70163_u - (double)downReach, Math.floor(playerIn.field_70161_v) + 0.5);
            block0: for (int i = 0; i < this.rollRadius; ++i) {
                for (int rollDepth = 0; rollDepth < 2; ++rollDepth) {
                    int h;
                    double zOff;
                    double xOff = i == 0 ? 0.0 : (double)Math.round(fwd.field_72449_c) * Math.ceil((double)i / 2.0);
                    double d = zOff = i == 0 ? 0.0 : (double)Math.round(fwd.field_72450_a) * Math.ceil((double)i / 2.0);
                    if (i % 2 == 0) {
                        xOff *= -1.0;
                        zOff *= -1.0;
                    }
                    if (playerIn.func_174811_aO().equals((Object)EnumFacing.NORTH) || playerIn.func_174811_aO().equals((Object)EnumFacing.SOUTH)) {
                        zOff = (rollDepth - 1) * playerIn.func_174811_aO().func_176743_c().func_179524_a();
                    } else {
                        xOff = (rollDepth - 1) * playerIn.func_174811_aO().func_176743_c().func_179524_a();
                    }
                    BlockPos checkPos = pos.func_177963_a(fwd.field_72450_a * 1.0 + xOff, 0.0, fwd.field_72449_c * 1.0 + zOff);
                    BlockPos inkPos = pos.func_177963_a(fwd.field_72450_a * 2.0 + xOff, -1.0, fwd.field_72449_c * 2.0 + zOff);
                    for (h = 0; h <= downReach && !SplatCraftUtils.canInkPassthrough(worldIn, inkPos.func_177984_a()); ++h) {
                        inkPos = inkPos.func_177984_a();
                    }
                    boolean canInk = SplatCraftUtils.canInk(worldIn, inkPos);
                    if (canInk && !worldIn.field_72995_K) {
                        SplatCraftUtils.playerInkBlock(playerIn, worldIn, inkPos, color, this.rollDamage, glowingInk);
                    }
                    EntityLivingBase knockbackEntity = null;
                    List inkedPlayers = worldIn.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(inkPos.func_177984_a()));
                    int j = 0;
                    if (playerIn.func_184825_o(0.0f) >= 1.0f) {
                        for (EntityLivingBase target : inkedPlayers) {
                            if (target.equals((Object)playerIn)) continue;
                            boolean isTargetSameColor = false;
                            if (target instanceof EntityPlayer) {
                                isTargetSameColor = SplatCraftPlayerData.getInkColor((EntityPlayer)target) == color;
                            }
                            float rollDamage = this.rollDamage;
                            boolean damaged = SplatCraftUtils.dealRollDamage(worldIn, target, rollDamage, color, (Entity)playerIn, false, glowingInk);
                            if (target instanceof EntitySquidBumper && ((EntitySquidBumper)target).getColor() == color || !damaged) {
                                rollDamage = 0.0f;
                            }
                            if (!isTargetSameColor && (!(target.func_110143_aJ() - rollDamage > 0.0f) && !(target instanceof EntitySquidBumper) || target instanceof EntitySquidBumper && ((EntitySquidBumper)target).getInkHealth() - rollDamage > 0.0f)) {
                                knockbackEntity = target;
                            }
                            if (++j < 5) continue;
                            knockbackEntity = target;
                            break;
                        }
                    }
                    if (knockbackEntity != null && worldIn.field_72995_K) {
                        this.applyEntityCollision((Entity)knockbackEntity, (Entity)playerIn, 10.0);
                    }
                    if (h > downReach) continue block0;
                }
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
    }

    public void applyEntityCollision(Entity source, Entity target, double power) {
        double d1;
        double d0;
        double d2;
        if (!(target.func_184223_x(source) || target.equals((Object)source) || source.field_70145_X || target.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = target.field_70165_t - source.field_70165_t), (double)(d1 = target.field_70161_v - source.field_70161_v))) >= (double)0.01f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - source.field_70144_Y);
            d1 *= (double)(1.0f - source.field_70144_Y);
            d0 *= power;
            d1 *= power;
            if (!target.func_184207_aI()) {
                target.field_70159_w = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    @Override
    public AttributeModifier getSpeedModifier() {
        return this.SPEED_MODIFIER;
    }

    @Override
    public AttributeModifier getNoInkSpeed() {
        return this.NO_INK_SPEED_MODIFIER;
    }

    @Override
    public boolean onItemLeftClick(World worldIn, EntityPlayer playerIn, ItemStack stack) {
        if (ItemRollerBase.hasInk(playerIn, stack, this.flingConsumption)) {
            if (playerIn.func_184825_o(0.0f) >= 0.95f) {
                ItemRollerBase.reduceInk(playerIn, this.flingConsumption);
                for (int i = -1; i <= 1; ++i) {
                    EntityInkProjectile proj = new EntityInkProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.flingDamage);
                    proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z + (float)(!this.isBrush ? 0 : 20 * i), this.isBrush ? 0.0f : (float)(20 * i), this.flingSpeed, 4.0f);
                    proj.setProjectileSize(this.flingSize);
                    worldIn.func_72838_d((Entity)proj);
                }
                return true;
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
        return false;
    }

    @Override
    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.ROLLER;
    }

    private Vec3d getFwd(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }
}

