/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemShooterBase
extends ItemWeaponBase {
    public float projectileSize;
    public float inaccuracy;
    public float projectileSpeed;
    public int firingSpeed;
    public boolean automatic;
    public float damage;

    public ItemShooterBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConsumption, boolean automatic) {
        super(unlocName, registryName, inkConsumption);
        this.inaccuracy = inaccuracy;
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.firingSpeed = firingSpeed;
        this.automatic = automatic;
        this.damage = damage;
    }

    public ItemShooterBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConumption) {
        this(unlocName, registryName, projectileSize, projectileSpeed, inaccuracy, firingSpeed, damage, inkConumption, true);
    }

    public ItemShooterBase(String unlocName, String registryName, ItemShooterBase parent) {
        this(unlocName, registryName, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.firingSpeed, parent.damage, parent.inkConsumption, parent.automatic);
    }

    public ItemShooterBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemShooterBase)parent);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (!this.automatic && !worldIn.field_72995_K) {
            EntityInkProjectile proj = new EntityInkProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.damage);
            proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.projectileSpeed, this.inaccuracy);
            proj.setProjectileSize(this.projectileSize);
            worldIn.func_72838_d((Entity)proj);
            playerIn.func_184811_cZ().func_185145_a((Item)this, this.firingSpeed);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public int func_77626_a(ItemStack stack) {
        return this.automatic ? super.func_77626_a(stack) : 0;
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        int actualUseTime = this.func_77626_a(stack) - useTime;
        int startupLag = 2;
        if (this.hasInk(playerIn, stack)) {
            if (actualUseTime > startupLag && (actualUseTime - startupLag) % this.firingSpeed == 1 && this.automatic && !worldIn.field_72995_K) {
                this.reduceInk(playerIn);
                EntityInkProjectile proj = new EntityInkProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.damage);
                proj.shoot((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.projectileSpeed, this.inaccuracy);
                proj.setProjectileSize(this.projectileSize);
                worldIn.func_72838_d((Entity)proj);
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
    }

    @Override
    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.SHOOTER;
    }
}

