/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSlosherBase
extends ItemWeaponBase {
    public float projectileSize;
    public float projectileSpeed;
    public float damage;
    public int startupTicks;
    public int projectileCount;
    public float diffAngle;

    public ItemSlosherBase(String unlocName, String registryName, float projectileSize, float projectileSpeed, int projectileCount, float offsetBetweenProj, float damage, final int startupTicks, float inkConsumption) {
        super(unlocName, registryName, inkConsumption);
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.damage = damage;
        this.startupTicks = startupTicks;
        this.projectileCount = projectileCount;
        this.diffAngle = offsetBetweenProj;
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack) {
                    return ItemSlosherBase.this.func_77626_a(stack) - entityIn.func_184605_cv() < startupTicks * 2 ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }

    public ItemSlosherBase(String unlocName, String registryName, ItemSlosherBase parent) {
        this(unlocName, registryName, parent.projectileSize, parent.projectileSpeed, parent.projectileCount, parent.diffAngle, parent.damage, parent.startupTicks, parent.inkConsumption);
    }

    public ItemSlosherBase(String unlocName, String registryName, Item parent) {
        this(unlocName, registryName, (ItemSlosherBase)parent);
    }

    @Override
    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
        super.onItemTickUse(worldIn, playerIn, stack, useTime);
        int actualUseTime = this.func_77626_a(stack) - useTime;
        if (this.hasInk(playerIn, stack)) {
            if (actualUseTime == this.startupTicks && !worldIn.field_72995_K) {
                this.reduceInk(playerIn);
                for (int i = 0; i < this.projectileCount; ++i) {
                    boolean hasTrail = (double)i == Math.floor((float)(this.projectileCount - 1) / 2.0f) || (double)i == Math.ceil((float)(this.projectileCount - 1) / 2.0f);
                    float angle = this.diffAngle * (float)i - this.diffAngle * (float)(this.projectileCount - 1) / 2.0f;
                    EntityInkProjectile proj = new EntityInkProjectile(worldIn, (EntityLivingBase)playerIn, ColorItemUtils.getInkColor(stack), this.damage);
                    proj.setTrail(hasTrail);
                    proj.shoot((Entity)playerIn, Math.max(0.0f, playerIn.field_70125_A + 63.0f) - 90.0f, playerIn.field_70177_z + angle, 0.0f, this.projectileSpeed * (hasTrail ? 1.0f : 0.95f), 2.0f);
                    proj.setProjectileSize(this.projectileSize * (hasTrail ? 1.0f : 0.8f));
                    worldIn.func_72838_d((Entity)proj);
                }
            }
        } else {
            playerIn.func_146105_b(new TextComponentTranslation("status.noInk", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
        }
    }

    @Override
    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.BUCKET;
    }
}

