/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.entities.classes.EntitySquidBumper;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemSquidBumper
extends Item {
    public ItemSquidBumper(String unlocName, String registryName) {
        this.func_77655_b(unlocName);
        this.setRegistryName(registryName);
        this.func_77637_a(TabSplatCraft.main);
        ColorItemUtils.inkColorItems.add(this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ColorItemUtils.hasInkColor(stack)) {
            int color = ColorItemUtils.getInkColor(stack);
            tooltip.add(SplatCraftUtils.getColorName(color));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        double d2;
        double d1;
        ItemStack itemstack;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        boolean flag = worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockpos = flag ? pos : pos.func_177972_a(facing);
        if (!player.func_175151_a(blockpos, facing, itemstack = player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos1 = blockpos.func_177984_a();
        boolean flag1 = !worldIn.func_175623_d(blockpos) && !worldIn.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos);
        if (flag1 |= !worldIn.func_175623_d(blockpos1) && !worldIn.func_180495_p(blockpos1).func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos1)) {
            return EnumActionResult.FAIL;
        }
        double d0 = blockpos.func_177958_n();
        List list = worldIn.func_72839_b((Entity)null, new AxisAlignedBB(d0, d1 = (double)blockpos.func_177956_o(), d2 = (double)blockpos.func_177952_p(), d0 + 1.0, d1 + 2.0, d2 + 1.0));
        if (!list.isEmpty()) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_175698_g(blockpos);
            worldIn.func_175698_g(blockpos1);
            EntitySquidBumper bumperEntity = new EntitySquidBumper(worldIn, d0 + 0.5, d1, d2 + 0.5, ColorItemUtils.getInkColor(itemstack));
            float f = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(player.field_70177_z - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            bumperEntity.func_70012_b(d0 + 0.5, d1, d2 + 0.5, f, 0.0f);
            ItemMonsterPlacer.func_185079_a((World)worldIn, (EntityPlayer)player, (ItemStack)itemstack, (Entity)bumperEntity);
            worldIn.func_72838_d((Entity)bumperEntity);
            worldIn.func_184148_a(null, bumperEntity.field_70165_t, bumperEntity.field_70163_u, bumperEntity.field_70161_v, SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
        }
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ColorItemUtils.hasInkColor(stack) || !(entityIn instanceof EntityPlayer)) {
            return;
        }
        ColorItemUtils.setInkColor(stack, SplatCraftPlayerData.getInkColor((EntityPlayer)entityIn));
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u - 1.0, entityItem.field_70161_v);
        ItemStack stack = entityItem.func_92059_d();
        if (entityItem.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell) && entityItem.field_70170_p.func_175625_s(pos) instanceof TileEntityColor) {
            TileEntityColor te = (TileEntityColor)entityItem.field_70170_p.func_175625_s(pos);
            if (ColorItemUtils.getInkColor(stack) != te.getColor()) {
                ColorItemUtils.setInkColor(stack, te.getColor());
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }
}

