/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.commands.CommandTurfWar;
import com.cibernet.splatcraft.items.ItemRemote;
import com.cibernet.splatcraft.network.PacketSendColorScores;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemTurfScanner
extends ItemRemote {
    public ItemTurfScanner() {
        this.func_77655_b("turfScanner");
        this.setRegistryName("turf_scanner");
        this.func_77625_d(1);
        this.func_77637_a(TabSplatCraft.main);
        this.totalModes = 2;
    }

    @Override
    public ItemRemote.RemoteResult onRemoteUse(World world, BlockPos blockpos, BlockPos blockpos1, ItemStack stack, int colorIn, int mode) {
        return ItemTurfScanner.scanTurf(world, blockpos, blockpos1, stack, colorIn, mode, null);
    }

    public static ItemRemote.RemoteResult scanTurf(World world, BlockPos blockpos, BlockPos blockpos1, ItemStack stack, int colorIn, int mode, EntityPlayerMP target) {
        IBlockState checkState;
        BlockPos checkPos;
        int y;
        int z;
        int x;
        BlockPos blockpos2 = new BlockPos(Math.min(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.min(blockpos.func_177956_o(), Math.min(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.min(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        BlockPos blockpos3 = new BlockPos(Math.max(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.max(blockpos.func_177956_o(), Math.max(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.max(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        if (blockpos2.func_177956_o() < 0 || blockpos3.func_177956_o() >= 256) {
            return ItemTurfScanner.createResult(false, (TextComponentBase)new TextComponentTranslation("commands.turfWar.outOfWorld", new Object[0]));
        }
        for (int j = blockpos2.func_177952_p(); j <= blockpos3.func_177952_p(); j += 16) {
            for (int k = blockpos2.func_177958_n(); k <= blockpos3.func_177958_n(); k += 16) {
                if (world.func_175667_e(new BlockPos(k, blockpos3.func_177956_o() - blockpos2.func_177956_o(), j))) continue;
                return ItemTurfScanner.createResult(false, (TextComponentBase)new TextComponentTranslation("commands.turfWar.outOfWorld", new Object[0]));
            }
        }
        if (world.field_72995_K) {
            return ItemTurfScanner.createResult(true, null);
        }
        TreeMap<Integer, Integer> scores = new TreeMap<Integer, Integer>();
        int blockTotal = 0;
        if (mode == 0) {
            for (x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
                for (z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    y = CommandTurfWar.getTopSolidOrLiquidBlock(new BlockPos(x, 1, z), world, Math.min(blockpos3.func_177956_o() + 2, 255)).func_177977_b().func_177956_o();
                    if (y > blockpos3.func_177956_o() || y < blockpos2.func_177956_o()) continue;
                    checkPos = new BlockPos(x, y, z);
                    checkState = world.func_180495_p(checkPos);
                    if (!SplatCraftUtils.canInk(world, checkPos) || !checkState.func_185904_a().func_76230_c() || checkState.func_185904_a().func_76224_d() || !SplatCraftUtils.canInk(world, checkPos)) continue;
                    ++blockTotal;
                    if (!(world.func_175625_s(checkPos) instanceof TileEntityColor) || !(world.func_180495_p(checkPos).func_177230_c() instanceof IInked)) continue;
                    TileEntityColor te = (TileEntityColor)world.func_175625_s(checkPos);
                    IInked block = (IInked)world.func_180495_p(checkPos).func_177230_c();
                    int color = te.getColor();
                    if (!block.countsTowardsScore()) continue;
                    if (scores.containsKey(color)) {
                        scores.replace(color, (Integer)scores.get(color) + 1);
                        continue;
                    }
                    scores.put(color, 1);
                }
            }
        } else if (mode == 1) {
            for (x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
                for (z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    for (y = blockpos2.func_177956_o(); y <= blockpos3.func_177956_o(); ++y) {
                        checkPos = new BlockPos(x, y, z);
                        checkState = world.func_180495_p(checkPos);
                        boolean isWall = false;
                        for (int j = 1; j <= 2 && !world.func_189509_E(checkPos.func_177981_b(j)); ++j) {
                            if (!SplatCraftUtils.canInkPassthrough(world, checkPos.func_177981_b(j))) {
                                isWall = true;
                                break;
                            }
                            if (j > blockpos3.func_177956_o()) break;
                        }
                        if (isWall || !SplatCraftUtils.canInk(world, checkPos) || !checkState.func_185904_a().func_76230_c() || checkState.func_185904_a().func_76224_d() || !SplatCraftUtils.canInk(world, checkPos)) continue;
                        ++blockTotal;
                        if (!(world.func_175625_s(checkPos) instanceof TileEntityColor) || !(world.func_180495_p(checkPos).func_177230_c() instanceof IInked)) continue;
                        TileEntityColor te = (TileEntityColor)world.func_175625_s(checkPos);
                        IInked block = (IInked)world.func_180495_p(checkPos).func_177230_c();
                        int color = te.getColor();
                        if (!block.countsTowardsScore()) continue;
                        if (scores.containsKey(color)) {
                            scores.replace(color, (Integer)scores.get(color) + 1);
                            continue;
                        }
                        scores.put(color, 1);
                    }
                }
            }
        }
        Integer[] colors = new Integer[scores.size()];
        Float[] colorScores = new Float[scores.size()];
        int winner = -1;
        float winnerScore = -1.0f;
        int i = 0;
        for (Map.Entry entry : scores.entrySet()) {
            colors[i] = (Integer)entry.getKey();
            colorScores[i] = Float.valueOf((float)((Integer)entry.getValue()).intValue() / (float)blockTotal * 100.0f);
            if (winnerScore < (float)((Integer)entry.getValue()).intValue()) {
                winner = (Integer)entry.getKey();
                winnerScore = ((Integer)entry.getValue()).intValue();
            }
            ++i;
        }
        for (Map.Entry entry : scores.entrySet()) {
            if (!SplatcraftScoreboardHandler.hasGoal((Integer)entry.getKey())) continue;
            Iterator iter = (Integer)entry.getKey() == winner ? world.func_96441_U().func_96520_a((IScoreCriteria)SplatcraftScoreboardHandler.getColorWins((Integer)entry.getKey())).iterator() : world.func_96441_U().func_96520_a((IScoreCriteria)SplatcraftScoreboardHandler.getColorLosses((Integer)entry.getKey())).iterator();
            while (iter.hasNext()) {
                Iterator scoreIter = world.func_96441_U().func_96534_i((ScoreObjective)iter.next()).iterator();
                while (scoreIter.hasNext()) {
                    ((Score)scoreIter.next()).func_96649_a(1);
                }
            }
        }
        if (scores.isEmpty()) {
            return ItemTurfScanner.createResult(false, (TextComponentBase)new TextComponentTranslation("commands.turfWar.noInk", new Object[0]));
        }
        PacketSendColorScores packet = new PacketSendColorScores(colors, colorScores);
        if (target == null) {
            SplatCraftPacketHandler.instance.sendToDimension((IMessage)packet, world.field_73011_w.getDimension());
        } else {
            SplatCraftPacketHandler.instance.sendTo((IMessage)packet, target);
        }
        return ItemTurfScanner.createResult(true, null);
    }
}

