/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.SplatCraftConfig;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.items.IBattleItem;
import com.cibernet.splatcraft.items.ItemInkTank;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ClientUtils;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemWeaponBase
extends Item
implements IBattleItem {
    public static List<ItemWeaponBase> weapons = new ArrayList<ItemWeaponBase>();
    public float inkConsumption;

    public ItemWeaponBase(String unlocName, String registryName, float inkConsumption) {
        this.func_77655_b(unlocName);
        this.setRegistryName(registryName);
        this.func_77637_a(TabSplatCraft.main);
        this.func_77625_d(1);
        ColorItemUtils.inkColorItems.add(this);
        weapons.add(this);
        this.inkConsumption = inkConsumption;
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (ColorItemUtils.isColorLocked(stack)) {
            int color = ColorItemUtils.getInkColor(stack);
            tooltip.add(SplatCraftUtils.getColorName(color));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ColorItemUtils.isColorLocked(stack) || !(entityIn instanceof EntityPlayer)) {
            return;
        }
        ColorItemUtils.setInkColor(stack, SplatCraftPlayerData.getInkColor((EntityPlayer)entityIn));
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving.func_184607_cu().equals(stack)) {
            entityLiving.func_184602_cy();
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!entityLiving.field_70170_p.field_72995_K) {
            boolean isSquid = false;
            if (entityLiving instanceof EntityPlayer) {
                isSquid = SplatCraftPlayerData.getIsSquid((EntityPlayer)entityLiving);
                if (((EntityPlayer)entityLiving).func_175149_v()) {
                    return true;
                }
            }
            if (!isSquid) {
                this.onItemLeftClick(entityLiving.field_70170_p, (EntityPlayer)entityLiving, stack);
                return super.onEntitySwing(entityLiving, stack);
            }
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        BlockPos pos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u - 1.0, entityItem.field_70161_v);
        ItemStack stack = entityItem.func_92059_d();
        if (entityItem.field_70170_p.func_180495_p(pos).func_177230_c().equals(SplatCraftBlocks.inkwell)) {
            if (entityItem.field_70170_p.func_175625_s(pos) instanceof TileEntityColor) {
                TileEntityColor te = (TileEntityColor)entityItem.field_70170_p.func_175625_s(pos);
                if (ColorItemUtils.getInkColor(stack) != te.getColor() || !ColorItemUtils.isColorLocked(stack)) {
                    ColorItemUtils.setInkColor(stack, te.getColor());
                    ColorItemUtils.setColorLocked(stack, true);
                }
            }
        } else if (entityItem.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a().equals(Material.field_151586_h) && ColorItemUtils.isColorLocked(stack)) {
            ColorItemUtils.setInkColor(stack, InkColors.DYE_WHITE.getColor());
            ColorItemUtils.setColorLocked(stack, false);
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        try {
            return ClientUtils.getDurabilityForDisplay(stack);
        }
        catch (NoClassDefFoundError e) {
            return 1.0;
        }
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return SplatCraftConfig.dynamicInkDurabilityColor ? ColorItemUtils.getInkColor(stack) : super.getRGBDurabilityForDisplay(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        try {
            return ClientUtils.showDurabilityBar(stack);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void onItemTickUse(World worldIn, EntityPlayer playerIn, ItemStack stack, int useTime) {
    }

    public AttributeModifier getSpeedModifier() {
        return null;
    }

    public boolean onItemLeftClick(World world, EntityPlayer player, ItemStack stack) {
        return false;
    }

    public ModelPlayerOverride.EnumAnimType getAnimType() {
        return ModelPlayerOverride.EnumAnimType.NONE;
    }

    public boolean hasInk(EntityPlayer player, ItemStack weapon) {
        return ItemWeaponBase.hasInk(player, weapon, this.inkConsumption);
    }

    public static boolean hasInk(EntityPlayer player, ItemStack weapon, float offset) {
        int color = ColorItemUtils.getInkColor(weapon);
        if (!SplatCraftGamerules.getGameruleValue("requireInkTank")) {
            return true;
        }
        ItemStack chespiece = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return chespiece.func_77973_b() instanceof ItemInkTank && ColorItemUtils.getInkColor(chespiece) == color && ItemInkTank.getInkAmountStatic(chespiece, weapon) - offset > 0.0f;
    }

    public static void reduceInk(EntityPlayer player, float amount) {
        if (!SplatCraftGamerules.getGameruleValue("requireInkTank")) {
            return;
        }
        ItemStack chespiece = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chespiece.func_77973_b() instanceof ItemInkTank) {
            ItemInkTank.setInkAmount(chespiece, ItemInkTank.getInkAmount(chespiece) - amount);
        }
    }

    public void reduceInk(EntityPlayer player) {
        ItemWeaponBase.reduceInk(player, this.inkConsumption);
    }

    public AttributeModifier getNoInkSpeed() {
        return null;
    }
}

