/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.network.PacketReturnChargeRelease;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChargeRelease
implements IMessage {
    private boolean messageValid;
    private ItemStack stack;
    private UUID player;

    public PacketChargeRelease() {
        this.messageValid = false;
    }

    public PacketChargeRelease(UUID player, ItemStack stack) {
        this.messageValid = true;
        this.player = player;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketChargeRelease, IMessage> {
        public IMessage onMessage(PacketChargeRelease message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketChargeRelease message, MessageContext ctx) {
            try {
                float charge = SplatCraftPlayerData.getWeaponCharge(message.player, message.stack);
                if (charge > 0.05f) {
                    SplatCraftPacketHandler.instance.sendToServer((IMessage)new PacketReturnChargeRelease(charge, message.stack));
                    SplatCraftPlayerData.setWeaponCharge(message.player, message.stack, 0.0f);
                }
                SplatCraftPlayerData.setCanDischarge(message.player, true);
            }
            catch (Exception e) {
                SplatCraft.logger.info(e.toString());
            }
        }
    }
}

