/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.recipes.RecipeSubtype;
import com.cibernet.splatcraft.recipes.RecipesWeaponStation;
import com.cibernet.splatcraft.registries.SplatCraftStats;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCraftWeapon
implements IMessage {
    private boolean messageValid;
    RecipeSubtype recipe;

    public PacketCraftWeapon() {
        this.messageValid = false;
    }

    public PacketCraftWeapon(RecipeSubtype recipe) {
        this.messageValid = true;
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.recipe = RecipesWeaponStation.getRecipeByID(buf.readInt());
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(RecipesWeaponStation.getRecipeID(this.recipe));
    }

    public static class Handler
    implements IMessageHandler<PacketCraftWeapon, IMessage> {
        public IMessage onMessage(PacketCraftWeapon message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketCraftWeapon message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            RecipeSubtype recipe = message.recipe;
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                RecipesWeaponStation.getItem((EntityPlayer)player, recipe.getIngredients().get(i), true);
            }
            SplatCraftUtils.giveItem((EntityPlayer)player, recipe.getOutput().func_77946_l());
            player.func_71029_a(SplatCraftStats.WEAPONS_CRAFTED);
        }
    }
}

