/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.items.ItemDualieBase;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDodgeRoll
implements IMessage {
    private boolean messageValid;
    boolean useOffhandValues;
    int cooldown;

    public PacketDodgeRoll() {
        this.messageValid = false;
    }

    public PacketDodgeRoll(boolean useOffhandValues, int cooldown) {
        this.messageValid = true;
        this.useOffhandValues = useOffhandValues;
        this.cooldown = cooldown;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.useOffhandValues = buf.readBoolean();
            this.cooldown = buf.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeBoolean(this.useOffhandValues);
        buf.writeInt(this.cooldown);
    }

    public static class Handler
    implements IMessageHandler<PacketDodgeRoll, IMessage> {
        public IMessage onMessage(PacketDodgeRoll message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketDodgeRoll message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            CooldownTracker cooldownTracker = player.func_184811_cZ();
            ItemStack weapon = player.func_184607_cu();
            if (weapon.func_77973_b() instanceof ItemDualieBase) {
                ItemStack offhandStack = player.func_184586_b(player.func_184614_ca().equals(weapon.func_77973_b()) ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
                if (message.useOffhandValues) {
                    weapon = offhandStack;
                }
                cooldownTracker.func_185145_a(weapon.func_77973_b(), message.cooldown);
                if (offhandStack.func_77973_b() instanceof ItemDualieBase) {
                    cooldownTracker.func_185145_a(offhandStack.func_77973_b(), message.cooldown);
                }
                ItemWeaponBase.reduceInk((EntityPlayer)player, ((ItemDualieBase)weapon.func_77973_b()).rollConsumption);
                SplatCraftUtils.createInkExplosion(player.field_70170_p, (Entity)player, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 0.5f, 0.0f, ColorItemUtils.getInkColor(weapon), SplatCraftUtils.getPlayerGlowingInk((EntityPlayer)player));
            }
        }
    }
}

