/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.utils.ClientUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketInkLandParticles
implements IMessage {
    private boolean messageValid;
    int color;
    int numberOfParticles;
    int source;
    double yPos;

    public PacketInkLandParticles() {
        this.messageValid = false;
    }

    public PacketInkLandParticles(int color, int numberOfParticles, double yPos, Entity source) {
        this.messageValid = true;
        this.color = color;
        this.numberOfParticles = numberOfParticles;
        this.yPos = yPos;
        this.source = source.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.color = buf.readInt();
            this.numberOfParticles = buf.readInt();
            this.yPos = buf.readDouble();
            this.source = buf.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.color);
        buf.writeInt(this.numberOfParticles);
        buf.writeDouble(this.yPos);
        buf.writeInt(this.source);
    }

    public static class Handler
    implements IMessageHandler<PacketInkLandParticles, IMessage> {
        public IMessage onMessage(PacketInkLandParticles message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketInkLandParticles message, MessageContext ctx) {
            try {
                World world = ClientUtils.getClientWorld();
                Entity entity = world.func_73045_a(message.source);
                double speed = 0.15f;
                int color = message.color;
                for (int i = 0; i < message.numberOfParticles; ++i) {
                    double angle = entity.field_70170_p.field_73012_v.nextDouble() * Math.PI;
                    SplatCraftParticleSpawner.spawnInkParticle(entity.field_70165_t, message.yPos, entity.field_70161_v, Math.sin(angle) * speed, speed / 2.0, Math.cos(angle) * speed, color, 1.8f);
                }
            }
            catch (Exception e) {
                SplatCraft.logger.info(e.toString());
            }
        }
    }
}

