/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayerReturnColor
implements IMessage {
    private boolean messageValid;
    private UUID player;
    private int color;

    public PacketPlayerReturnColor() {
        this.messageValid = false;
    }

    public PacketPlayerReturnColor(UUID player, int color) {
        this.messageValid = true;
        this.color = color;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.color = buf.readInt();
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.color);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerReturnColor, IMessage> {
        public IMessage onMessage(PacketPlayerReturnColor message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketPlayerReturnColor message, MessageContext ctx) {
            try {
                SplatCraftPlayerData.getPlayerData((UUID)((PacketPlayerReturnColor)message).player).inkColor = message.color;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

