/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayerReturnTransformed
implements IMessage {
    private boolean messageValid;
    private UUID player;
    private boolean isTransformed;

    public PacketPlayerReturnTransformed() {
        this.messageValid = false;
    }

    public PacketPlayerReturnTransformed(UUID player, boolean isTransformed) {
        this.messageValid = true;
        this.isTransformed = isTransformed;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.isTransformed = buf.readBoolean();
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeBoolean(this.isTransformed);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerReturnTransformed, IMessage> {
        public IMessage onMessage(PacketPlayerReturnTransformed message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketPlayerReturnTransformed message, MessageContext ctx) {
            try {
                if (SplatCraftPlayerData.getPlayerData((UUID)((PacketPlayerReturnTransformed)message).player).isSquid < 1 == message.isTransformed) {
                    SplatCraftPlayerData.getPlayerData((UUID)((PacketPlayerReturnTransformed)message).player).isSquid = message.isTransformed ? 2 : 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

