/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.network.PacketPlayerReturnColor;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayerSetColor
implements IMessage {
    private boolean messageValid;
    private UUID player;
    private int color;

    public PacketPlayerSetColor() {
        this.messageValid = false;
    }

    public PacketPlayerSetColor(UUID player, int color) {
        this.messageValid = true;
        this.player = player;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.color = buf.readInt();
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.color);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerSetColor, IMessage> {
        public IMessage onMessage(PacketPlayerSetColor message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketPlayerSetColor message, MessageContext ctx) {
            SplatCraftPlayerData.getPlayerData((UUID)((PacketPlayerSetColor)message).player).inkColor = message.color;
            SplatCraftPacketHandler.instance.sendToDimension((IMessage)new PacketPlayerReturnColor(message.player, message.color), ctx.getServerHandler().field_147369_b.field_71093_bK);
        }
    }
}

