/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.network.PacketPlayerReturnTransformed;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPlayerSetTransformed
implements IMessage {
    private boolean messageValid;
    private UUID player;
    private boolean isTransformed;

    public PacketPlayerSetTransformed() {
        this.messageValid = false;
    }

    public PacketPlayerSetTransformed(UUID player, boolean isTransformed) {
        this.messageValid = true;
        this.player = player;
        this.isTransformed = isTransformed;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.isTransformed = buf.readBoolean();
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeBoolean(this.isTransformed);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerSetTransformed, IMessage> {
        public IMessage onMessage(PacketPlayerSetTransformed message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketPlayerSetTransformed message, MessageContext ctx) {
            SplatCraftPlayerData.getPlayerData((UUID)((PacketPlayerSetTransformed)message).player).isSquid = message.isTransformed ? 2 : 1;
            SplatCraftPacketHandler.instance.sendToDimension((IMessage)new PacketPlayerReturnTransformed(message.player, message.isTransformed), ctx.getServerHandler().field_147369_b.field_71093_bK);
        }
    }
}

