/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.items.ICharge;
import com.cibernet.splatcraft.items.ItemChargerBase;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnChargeRelease
implements IMessage {
    private boolean messageValid;
    private float charge;
    private ItemStack stack;

    public PacketReturnChargeRelease() {
        this.messageValid = false;
    }

    public PacketReturnChargeRelease(float charge, ItemStack stack) {
        this.messageValid = true;
        this.charge = charge;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.charge = buf.readFloat();
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeFloat(this.charge);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnChargeRelease, IMessage> {
        public IMessage onMessage(PacketReturnChargeRelease message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketReturnChargeRelease message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = message.stack;
            SplatCraftPlayerData.setWeaponCharge((EntityPlayer)player, stack, message.charge);
            if (stack.func_77973_b() instanceof ICharge) {
                ((ICharge)stack.func_77973_b()).onRelease(player.field_70170_p, (EntityPlayer)player, stack);
                if (stack.func_77973_b() instanceof ItemChargerBase) {
                    ItemChargerBase cfr_ignored_0 = (ItemChargerBase)stack.func_77973_b();
                    ItemChargerBase.reduceInk((EntityPlayer)player, ((ItemChargerBase)stack.func_77973_b()).getInkConsumption(message.charge));
                }
            }
        }
    }
}

