/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnPlayerData
implements IMessage {
    private boolean messageValid;
    private UUID player;
    private NBTTagCompound playerData;

    public PacketReturnPlayerData() {
        this.messageValid = false;
    }

    public PacketReturnPlayerData(UUID player, NBTTagCompound playerData) {
        this.messageValid = true;
        this.player = player;
        this.playerData = playerData;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.playerData = ByteBufUtils.readTag((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.playerData);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnPlayerData, IMessage> {
        public IMessage onMessage(PacketReturnPlayerData message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketReturnPlayerData message, MessageContext ctx) {
            try {
                SplatCraftPlayerData.readFromNBT(message.playerData);
            }
            catch (Exception e) {
                SplatCraft.logger.info(e.toString());
            }
        }
    }
}

