/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSendColorScores
implements IMessage {
    private boolean messageValid;
    Integer[] colors;
    Float[] scores;
    int length;

    public PacketSendColorScores() {
        this.messageValid = false;
    }

    public PacketSendColorScores(Integer[] colors, Float[] scores) {
        this.messageValid = true;
        this.colors = colors;
        this.scores = scores;
        this.length = Math.min(colors.length, scores.length);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            int i;
            ArrayList<Integer> colorList = new ArrayList<Integer>();
            ArrayList<Float> scoreList = new ArrayList<Float>();
            this.length = buf.readInt();
            for (i = 0; i < this.length; ++i) {
                colorList.add(buf.readInt());
            }
            for (i = 0; i < this.length; ++i) {
                scoreList.add(Float.valueOf(buf.readFloat()));
            }
            this.colors = colorList.toArray(new Integer[colorList.size()]);
            this.scores = scoreList.toArray(new Float[scoreList.size()]);
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        int i;
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.length);
        for (i = 0; i < this.length; ++i) {
            buf.writeInt(this.colors[i].intValue());
        }
        for (i = 0; i < this.length; ++i) {
            buf.writeFloat(this.scores[i].floatValue());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSendColorScores, IMessage> {
        public IMessage onMessage(PacketSendColorScores message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketSendColorScores message, MessageContext ctx) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int winner = -1;
            float winnerScore = -1.0f;
            for (int i = 0; i < message.colors.length; ++i) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"commands.turfWar.score", (Object[])new Object[]{SplatCraftUtils.getColorName(message.colors[i]), String.format("%.1f", message.scores[i])})));
                if (!(winnerScore < message.scores[i].floatValue())) continue;
                winnerScore = message.scores[i].floatValue();
                winner = message.colors[i];
            }
            if (winner != -1) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.turfWar.winner", new Object[]{SplatCraftUtils.getColorName(winner)}));
            }
        }
    }
}

