/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.tileentities.TileEntityInkwellVat;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSetVatOutput
implements IMessage {
    private boolean messageValid;
    BlockPos pos;
    ItemStack recipe;
    int selected;

    public PacketSetVatOutput() {
        this.messageValid = false;
    }

    public PacketSetVatOutput(TileEntityInkwellVat te, ItemStack recipe, int selected) {
        this.messageValid = true;
        this.pos = te.func_174877_v();
        this.recipe = recipe;
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
            this.recipe = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.selected = buf.readInt();
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.recipe);
        buf.writeInt(this.selected);
    }

    public static class Handler
    implements IMessageHandler<PacketSetVatOutput, IMessage> {
        public IMessage onMessage(PacketSetVatOutput message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketSetVatOutput message, MessageContext ctx) {
            try {
                TileEntityInkwellVat te = (TileEntityInkwellVat)ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
                te.setOutput(message.selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

