/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketUpdateGamerule
implements IMessage {
    private boolean messageValid;
    NBTTagCompound ruleNBT;

    public PacketUpdateGamerule() {
        this.messageValid = false;
    }

    public PacketUpdateGamerule(NBTTagCompound ruleNBT) {
        this.messageValid = true;
        this.ruleNBT = ruleNBT;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.ruleNBT = ByteBufUtils.readTag((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.ruleNBT);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateGamerule, IMessage> {
        public IMessage onMessage(PacketUpdateGamerule message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketUpdateGamerule message, MessageContext ctx) {
            try {
                SplatCraftGamerules.readFromNBT(message.ruleNBT);
            }
            catch (Exception e) {
                SplatCraft.logger.info(e.toString());
            }
        }
    }
}

