/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.network;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketWeaponLeftClick
implements IMessage {
    private boolean messageValid;
    private UUID player;

    public PacketWeaponLeftClick() {
        this.messageValid = false;
    }

    public PacketWeaponLeftClick(UUID player) {
        this.messageValid = true;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.player = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException e) {
            SplatCraft.logger.info(e.toString());
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.player.toString());
    }

    public static class Handler
    implements IMessageHandler<PacketWeaponLeftClick, IMessage> {
        public IMessage onMessage(PacketWeaponLeftClick message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.process(message, ctx));
            return null;
        }

        void process(PacketWeaponLeftClick message, MessageContext ctx) {
            try {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77973_b() instanceof ItemWeaponBase) {
                    ((ItemWeaponBase)stack.func_77973_b()).onItemLeftClick(player.field_70170_p, (EntityPlayer)player, stack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

