/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.proxy;

import com.cibernet.splatcraft.SplatCraftConfig;
import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.blocks.BlockInkwell;
import com.cibernet.splatcraft.entities.classes.EntityBlasterProjectile;
import com.cibernet.splatcraft.entities.classes.EntityChargerProjectile;
import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.entities.classes.EntityNPCSquid;
import com.cibernet.splatcraft.entities.classes.EntitySquidBumper;
import com.cibernet.splatcraft.entities.models.ModelArmorOverride;
import com.cibernet.splatcraft.entities.models.ModelPlayerOverride;
import com.cibernet.splatcraft.entities.renderers.RenderInkProjectile;
import com.cibernet.splatcraft.entities.renderers.RenderNPCSquid;
import com.cibernet.splatcraft.entities.renderers.RenderSquidBumper;
import com.cibernet.splatcraft.entities.renderers.RenderStageBarrier;
import com.cibernet.splatcraft.gui.GuiOverlay;
import com.cibernet.splatcraft.handlers.ClientEventHandler;
import com.cibernet.splatcraft.handlers.SplatCraftKeyHandler;
import com.cibernet.splatcraft.items.ItemBlockInkColor;
import com.cibernet.splatcraft.proxy.CommonProxy;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.registries.SplatCraftItems;
import com.cibernet.splatcraft.registries.SplatCraftModelManager;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkwellVat;
import com.cibernet.splatcraft.tileentities.TileEntityStageBarrier;
import com.cibernet.splatcraft.tileentities.TileEntitySunkenCrate;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ClientProxy
extends CommonProxy {
    protected static void registerRenderers() {
        Minecraft mc = Minecraft.func_71410_x();
        Item[] inkColorItems = ColorItemUtils.inkColorItems.toArray(new Item[ColorItemUtils.inkColorItems.size()]);
        Block[] inkColorBlocks = new Block[BlockInkColor.blocks.size()];
        for (int i = 0; i < BlockInkColor.blocks.size(); ++i) {
            inkColorBlocks[i] = BlockInkColor.blocks.get(i);
        }
        mc.getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return ColorItemUtils.getInkColor(stack);
            }
            return -1;
        }, inkColorItems);
        mc.getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return BlockInkwell.getInkColor(stack);
            }
            return -1;
        }, ItemBlockInkColor.itemList.toArray(new Item[ItemBlockInkColor.itemList.size()]));
        mc.func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> {
            TileEntityColor te;
            if (tintIndex != 0 || !(worldIn.func_175625_s(pos) instanceof TileEntityColor)) {
                return -1;
            }
            if (worldIn.func_175625_s(pos) instanceof TileEntitySunkenCrate && ((TileEntitySunkenCrate)(te = (TileEntitySunkenCrate)worldIn.func_175625_s(pos))).getState() == 0) {
                return -1;
            }
            te = (TileEntityColor)worldIn.func_175625_s(pos);
            return te.getColor();
        }, inkColorBlocks);
        mc.func_184125_al().func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn.func_175625_s(pos) instanceof TileEntityInkwellVat) {
                TileEntityInkwellVat te = (TileEntityInkwellVat)worldIn.func_175625_s(pos);
                return te.getColor();
            }
            return -1;
        }, new Block[]{SplatCraftBlocks.inkwellVat});
    }

    public static EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    public static void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register(SplatCraftModelManager.class);
        MinecraftForge.EVENT_BUS.register((Object)GuiOverlay.instance);
        SplatCraftKeyHandler.instance.registerKeys();
        RenderingRegistry.registerEntityRenderingHandler(EntityNPCSquid.class, manager -> new RenderNPCSquid(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySquidBumper.class, manager -> new RenderSquidBumper(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityInkProjectile.class, manager -> new RenderInkProjectile(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityChargerProjectile.class, manager -> new RenderInkProjectile(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlasterProjectile.class, manager -> new RenderInkProjectile(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStageBarrier.class, (TileEntitySpecialRenderer)new RenderStageBarrier());
        SplatCraftItems.registerArmorModels();
    }

    @Override
    public void init() {
        super.init();
        ClientProxy.registerRenderers();
        MinecraftForge.EVENT_BUS.register((Object)ClientEventHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new SplatCraftConfig());
    }

    @Override
    public void postInit() {
        super.postInit();
        this.overridePlayerModels();
    }

    private void overridePlayerModels() {
        Map skinMap = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)Minecraft.func_71410_x().func_175598_ae(), (String[])new String[]{"field_178636_l"});
        if (skinMap == null) {
            return;
        }
        RenderPlayer defaultRender = (RenderPlayer)skinMap.get("default");
        this.overridePlayerModels(defaultRender, false);
        RenderPlayer slimRender = (RenderPlayer)skinMap.get("slim");
        this.overridePlayerModels(slimRender, true);
    }

    private void overridePlayerModels(RenderPlayer renderPlayer, boolean slim) {
        LayerRenderer armorLayer;
        ModelBase oldModel = (ModelBase)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderPlayer, (String[])new String[]{"field_77045_g"});
        ObfuscationReflectionHelper.setPrivateValue(RenderLivingBase.class, (Object)renderPlayer, (Object)((Object)new ModelPlayerOverride(oldModel, 0.0f, slim)), (String[])new String[]{"field_77045_g"});
        List layers = (List)ObfuscationReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)renderPlayer, (String[])new String[]{"field_177097_h"});
        if (layers != null && (armorLayer = (LayerRenderer)layers.stream().filter(layer -> layer instanceof LayerBipedArmor).findFirst().orElse(null)) != null) {
            Field field = ReflectionHelper.findField(LayerArmorBase.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)LayerArmorBase.class.getName(), (String[])new String[]{"field_177186_d"}));
            field.setAccessible(true);
            try {
                field.set(armorLayer, (Object)new ModelArmorOverride());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

