/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.recipes;

import com.cibernet.splatcraft.items.ItemFilter;
import com.cibernet.splatcraft.registries.SplatCraftItems;
import com.cibernet.splatcraft.utils.InkColors;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesInkwellVat {
    private static final Hashtable<ItemFilter, List<InkColors>> recipes = new Hashtable();
    private static final ItemFilter EMPTY = new ItemFilter("", "", false);

    public static void registerRecipes() {
        RecipesInkwellVat.addToEmpty(InkColors.ORANGE, InkColors.BLUE, InkColors.GREEN, InkColors.PINK, InkColors.LIGHT_BLUE, InkColors.YELLOW, InkColors.TURQUOISE, InkColors.LILAC, InkColors.LEMON, InkColors.PLUM);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterEmpty, InkColors.INK_BLACK);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterEnchanted, InkColors.MOJANG, InkColors.COBALT, InkColors.ICEARSTORM, InkColors.FLORAL);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterNeon, InkColors.NEON_GREEN, InkColors.NEON_PINK, InkColors.NEON_ORANGE, InkColors.NEON_BLUE, InkColors.SQUID, InkColors.OCTO);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterPastel, InkColors.TANGERINE, InkColors.CYAN, InkColors.CHERRY, InkColors.MINT);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterDye, InkColors.DYE_ORANGE, InkColors.DYE_BLUE, InkColors.DYE_PINK, InkColors.DYE_LIME, InkColors.DYE_PURPLE, InkColors.DYE_LIGHT_BLUE, InkColors.DYE_MAGENTA, InkColors.DYE_YELLOW, InkColors.DYE_RED, InkColors.DYE_GREEN, InkColors.DYE_BROWN, InkColors.DYE_CYAN, InkColors.DYE_WHITE, InkColors.DYE_GRAY, InkColors.DYE_SILVER, InkColors.DYE_BLACK);
        RecipesInkwellVat.addRecipe(SplatCraftItems.filterCreative, InkColors.values());
    }

    public static void addRecipe(ItemFilter item, InkColors ... colors) {
        List<InkColors> list = Arrays.asList(colors);
        if (recipes.containsKey((Object)item)) {
            recipes.get((Object)item).addAll(list);
        } else {
            recipes.put(item, list);
        }
    }

    public static void addToEmpty(InkColors ... colors) {
        RecipesInkwellVat.addRecipe(EMPTY, colors);
    }

    public static List<InkColors> getOutput(@Nonnull ItemStack item) {
        List<InkColors> colors = recipes.get(item.func_77973_b());
        return colors == null ? recipes.get((Object)EMPTY) : colors;
    }

    public static boolean hasOutput(ItemStack input) {
        return recipes.containsKey(input);
    }

    public static Hashtable<ItemFilter, List<InkColors>> getRecipes() {
        return recipes;
    }

    protected static String[] getDictionaryNames(@Nonnull ItemStack stack) {
        int[] itemIDs = OreDictionary.getOreIDs((ItemStack)stack);
        String[] itemNames = new String[itemIDs.length];
        for (int i = 0; i < itemIDs.length; ++i) {
            itemNames[i] = OreDictionary.getOreName((int)itemIDs[i]);
        }
        return itemNames;
    }
}

