/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.registries;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SplatCraftModelManager {
    public static final List<Item> items = new ArrayList<Item>();
    public static final List<Block> blocks = new ArrayList<Block>();

    @SubscribeEvent
    public static void handleModelRegistry(ModelRegistryEvent event) {
        SplatCraftModelManager.ItemModels();
        SplatCraftModelManager.ItemBlockModels();
    }

    private static void ItemModels() {
        for (Item item : items) {
            SplatCraftModelManager.register(item);
        }
    }

    private static void ItemBlockModels() {
        for (Block block : blocks) {
            SplatCraftModelManager.register(block);
        }
    }

    private static void register(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), "inventory"));
    }

    private static void register(Item item, int meta, String modelResource) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("splatcraft:" + modelResource, "inventory"));
    }

    private static void register(Block block) {
        SplatCraftModelManager.register(Item.func_150898_a((Block)block));
    }

    private static void register(Block block, int meta, String modelResource) {
        SplatCraftModelManager.register(Item.func_150898_a((Block)block), meta, modelResource);
    }
}

