/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.scoreboard;

import com.cibernet.splatcraft.scoreboard.ScoreCriteriaInkColor;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class CommandColorScores
extends CommandBase {
    protected static final Map<Integer, ScoreCriteriaInkColor[]> COLOR_GOALS = Maps.newHashMap();

    public String func_71517_b() {
        return "colorscores";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.colorscores.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1 && args[0].equals("list")) {
            this.listGoals(sender, server);
            return;
        }
        if (args.length != 2) {
            throw new WrongUsageException("commands.colorscores.usage", new Object[0]);
        }
        InkColors ink = InkColors.getByName(args[1]);
        int color = ink != null ? ink.getColor() : (args[1].charAt(0) == '#' ? CommandColorScores.parseHex(args[1].substring(1).toLowerCase(), 0, 0xFFFFFF) : CommandColorScores.func_175764_a((String)args[1], (int)0, (int)0xFFFFFF));
        switch (args[0]) {
            case "add": {
                if (COLOR_GOALS.containsKey(color)) {
                    throw new CommandException("commands.colorscores.colorExists", new Object[]{SplatCraftUtils.getColorName(color)});
                }
                SplatcraftScoreboardHandler.createGoal(color);
                CommandColorScores.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.colorscores.add", (Object[])new Object[]{SplatCraftUtils.getColorName(color)});
                break;
            }
            case "remove": {
                if (!COLOR_GOALS.containsKey(color)) {
                    throw new CommandException("commands.colorscores.colorDoesntExist", new Object[]{SplatCraftUtils.getColorName(color)});
                }
                ArrayList conflictingObjectives = new ArrayList();
                for (ScoreCriteriaInkColor goal : COLOR_GOALS.get(color)) {
                    conflictingObjectives.addAll(server.func_71218_a(0).func_96441_U().func_96520_a((IScoreCriteria)goal));
                }
                if (!conflictingObjectives.isEmpty()) {
                    ArrayList objectiveNames = new ArrayList();
                    conflictingObjectives.forEach(objective -> objectiveNames.add(objective.func_96679_b()));
                    throw new CommandException("commands.colorscores.cantRemove", new Object[]{SplatCraftUtils.getColorName(color), String.join((CharSequence)", ", objectiveNames)});
                }
                for (ScoreCriteriaInkColor goal : COLOR_GOALS.get(color)) {
                    goal.remove();
                }
                COLOR_GOALS.remove(color);
                CommandColorScores.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.colorscores.remove", (Object[])new Object[]{SplatCraftUtils.getColorName(color)});
                break;
            }
            default: {
                throw new WrongUsageException("commands.colorscores.usage", new Object[0]);
            }
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandColorScores.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list"});
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "add": {
                    return CommandColorScores.func_175762_a((String[])args, InkColors.getNameSet());
                }
                case "remove": {
                    return CommandColorScores.func_71530_a((String[])args, (String[])CommandColorScores.getRegisteredGoalNames());
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected static String[] getRegisteredGoalNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int color : COLOR_GOALS.keySet()) {
            names.add(SplatCraftUtils.getUnlocColorName(color, true));
        }
        return names.toArray(new String[names.size()]);
    }

    protected void listGoals(ICommandSender sender, MinecraftServer server) throws CommandException {
        Set<Integer> collection = COLOR_GOALS.keySet();
        if (collection.isEmpty()) {
            throw new CommandException("commands.colorscores.list.empty", new Object[0]);
        }
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.colorscores.list.count", new Object[]{collection.size()});
        textcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        sender.func_145747_a((ITextComponent)textcomponenttranslation);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int color = (Integer)iterator.next();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.colorscores.list.entry", new Object[]{SplatCraftUtils.getUnlocColorName(color), SplatCraftUtils.getColorName(color)}));
        }
    }

    private static int parseHex(String input, int min, int max) throws NumberInvalidException {
        int i = CommandColorScores.parseHex(input);
        if (i < 0) {
            throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{i, min});
        }
        if (i > 0xFFFFFF) {
            throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{i, max});
        }
        return i;
    }

    private static int parseHex(String input) throws NumberInvalidException {
        try {
            return Integer.parseInt(input, 16);
        }
        catch (NumberFormatException var2) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
        }
    }
}

