/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.scoreboard;

import com.cibernet.splatcraft.scoreboard.CommandColorScores;
import com.cibernet.splatcraft.scoreboard.ScoreCriteriaInkColor;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;

public class SplatcraftScoreboardHandler {
    public static final IScoreCriteria COLOR = new ScoreCriteria("SC".toLowerCase() + ".inkColor");
    public static final IScoreCriteria INK = new ScoreCriteria("SC".toLowerCase() + ".inkUnits");

    public static void updatePlayerColorScore(EntityPlayer player, int color) {
        for (ScoreObjective objective : player.func_96123_co().func_96520_a(COLOR)) {
            player.func_96123_co().func_96529_a(player.func_70005_c_(), objective).func_96647_c(color);
        }
    }

    protected static void createGoal(int color) {
        CommandColorScores.COLOR_GOALS.put(color, new ScoreCriteriaInkColor[]{new ScoreCriteriaInkColor("colorKills", color), new ScoreCriteriaInkColor("deathsAsColor", color), new ScoreCriteriaInkColor("killsAsColor", color), new ScoreCriteriaInkColor("colorWins", color), new ScoreCriteriaInkColor("colorLosses", color)});
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound goalCompound = new NBTTagCompound();
        int[] colorArray = new int[CommandColorScores.COLOR_GOALS.keySet().size()];
        int i = 0;
        Iterator<Integer> iterator = CommandColorScores.COLOR_GOALS.keySet().iterator();
        while (iterator.hasNext()) {
            int color;
            colorArray[i] = color = iterator.next().intValue();
            ++i;
        }
        nbt.func_74783_a("storedGoals", colorArray);
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        CommandColorScores.COLOR_GOALS.clear();
        for (int color : nbt.func_74759_k("storedGoals")) {
            SplatcraftScoreboardHandler.createGoal(color);
        }
    }

    public static boolean hasGoal(int color) {
        return CommandColorScores.COLOR_GOALS.containsKey(color);
    }

    public static ScoreCriteriaInkColor getColorKills(int color) {
        return CommandColorScores.COLOR_GOALS.get(color)[0];
    }

    public static ScoreCriteriaInkColor getKillsAsColor(int color) {
        return CommandColorScores.COLOR_GOALS.get(color)[1];
    }

    public static ScoreCriteriaInkColor getDeathsAsColor(int color) {
        return CommandColorScores.COLOR_GOALS.get(color)[2];
    }

    public static ScoreCriteriaInkColor getColorWins(int color) {
        return CommandColorScores.COLOR_GOALS.get(color)[3];
    }

    public static ScoreCriteriaInkColor getColorLosses(int color) {
        return CommandColorScores.COLOR_GOALS.get(color)[4];
    }
}

