/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.tileentities;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.recipes.RecipesInkwellVat;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.registries.SplatCraftItems;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import com.cibernet.splatcraft.utils.InkColors;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileEntityInkwellVat
extends TileEntity
implements ISidedInventory {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private String customName;
    public int selectedColor = -1;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.selectedColor = compound.func_74762_e("selectedColor");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        compound.func_74768_a("selectedColor", this.selectedColor);
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, tagCompound);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setOutput(InkColors color) {
        int countA = this.func_70301_a(0).func_190916_E();
        int countB = this.func_70301_a(1).func_190916_E();
        int countC = this.func_70301_a(2).func_190916_E();
        int itemCount = Math.min(Math.max(0, Math.min(countA, Math.min(countB, countC))), Item.func_150898_a((Block)SplatCraftBlocks.inkwell).func_77639_j());
        if (countA > 0 && countB > 0 && countC > 0) {
            this.func_70299_a(4, ColorItemUtils.setInkColor(new ItemStack(SplatCraftBlocks.inkwell, 1), color.getColor()));
        } else {
            this.removeOutput();
        }
    }

    public boolean isActive() {
        return !this.func_70301_a(0).func_190926_b() && !this.func_70301_a(1).func_190926_b() && !this.func_70301_a(2).func_190926_b();
    }

    public void setOutput(int selectedColor) {
        List<InkColors> colorsList = this.getColorList();
        this.selectedColor = selectedColor;
        if (colorsList == null || selectedColor < 0 || selectedColor >= colorsList.size()) {
            this.removeOutput();
            this.selectedColor = -1;
        } else {
            this.setOutput(colorsList.get(selectedColor));
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public List<InkColors> getColorList() {
        ItemStack stack = this.getRecipeStack();
        int countA = this.func_70301_a(0).func_190916_E();
        int countB = this.func_70301_a(1).func_190916_E();
        int countC = this.func_70301_a(2).func_190916_E();
        if (countA <= 0 || countB <= 0 || countC <= 0) {
            return null;
        }
        return RecipesInkwellVat.getOutput(stack);
    }

    public int getColor() {
        if (!this.isActive()) {
            return -1;
        }
        List<InkColors> colorsList = this.getColorList();
        if (this.getColorList() == null || this.selectedColor < 0 || this.selectedColor >= this.getColorList().size()) {
            return SplatCraft.DEFAULT_INK;
        }
        return colorsList.get(this.selectedColor).getColor();
    }

    public ItemStack getRecipeStack() {
        return this.func_70301_a(3);
    }

    public void removeOutput() {
        this.func_70304_b(4);
    }

    public void dropInventoryItems() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack;
            if (i == 4 || (itemstack = this.func_70301_a(i)).func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)itemstack);
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack oldStack = (ItemStack)this.inventory.get(index);
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (index == 4 && !itemstack.func_190926_b() && count > 0) {
            if (this.func_70301_a(0).func_190916_E() < count || this.func_70301_a(1).func_190916_E() < count || this.func_70301_a(2).func_190916_E() < count) {
                return ItemStack.field_190927_a;
            }
            this.func_70298_a(0, count);
            this.func_70298_a(1, count);
            this.func_70298_a(2, count);
            oldStack.func_190920_e(1);
            int countA = this.func_70301_a(0).func_190916_E();
            int countB = this.func_70301_a(1).func_190916_E();
            int countC = this.func_70301_a(2).func_190916_E();
            int itemCount = Math.min(Math.max(0, Math.min(countA, Math.min(countB, countC))), Item.func_150898_a((Block)SplatCraftBlocks.inkwell).func_77639_j());
            if (itemCount > 0) {
                this.inventory.set(index, (Object)oldStack);
            }
        } else {
            this.setOutput(this.selectedColor);
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(index);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return stack.func_77969_a(new ItemStack(Items.field_151100_aR, 1, 0));
            }
            case 1: {
                return stack.func_77969_a(new ItemStack(SplatCraftItems.powerEgg));
            }
            case 2: {
                return stack.func_77969_a(new ItemStack(SplatCraftBlocks.emptyInkwell));
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return this.selectedColor;
    }

    public void func_174885_b(int id, int value) {
        this.selectedColor = value;
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public String func_70005_c_() {
        return "container.inkwellVat";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 4;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray = nArray3;
            nArray3[3] = 3;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

