/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.utils;

import com.cibernet.splatcraft.entities.models.ModelAbstractTank;
import com.cibernet.splatcraft.items.ItemInkTank;
import com.cibernet.splatcraft.items.ItemWeaponBase;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientUtils {
    public static ModelBiped getInkTankModel(ModelAbstractTank model, EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped _default) {
        if (!(stack.func_77973_b() instanceof ItemInkTank)) {
            return null;
        }
        if (model == null) {
            return null;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemInkTank) {
            model.field_178721_j.field_78806_j = slot == EntityEquipmentSlot.LEGS || slot == EntityEquipmentSlot.FEET;
            model.field_178722_k.field_78806_j = slot == EntityEquipmentSlot.LEGS || slot == EntityEquipmentSlot.FEET;
            model.field_78115_e.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            model.field_178724_i.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            model.field_178723_h.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            model.field_78116_c.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            model.field_178720_f.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            model.field_78117_n = _default.field_78117_n;
            model.field_78093_q = _default.field_78093_q;
            model.field_78091_s = _default.field_78091_s;
            model.field_187076_m = _default.field_187076_m;
            model.field_187075_l = _default.field_187075_l;
            return model;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getDurabilityForDisplay(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack chestpiece = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestpiece.func_77973_b() instanceof ItemInkTank && ItemWeaponBase.hasInk((EntityPlayer)player, stack, 0.0f)) {
            return 1.0f - ItemInkTank.getInkAmount(chestpiece) / ((ItemInkTank)chestpiece.func_77973_b()).capacity;
        }
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean showDurabilityBar(ItemStack stack) {
        return SplatCraftGamerules.getGameruleValue("requireInkTank") && (Minecraft.func_71410_x().field_71439_g.func_184614_ca().equals(stack) || Minecraft.func_71410_x().field_71439_g.func_184592_cb().equals(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71439_g.field_70170_p;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getFancyGraphics() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }
}

