/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.MapColor;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.common.util.EnumHelper;

public enum InkColors {
    ORANGE(14640154, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.ORANGE), "orange"),
    BLUE(2499231, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.BLUE), "blue"),
    PINK(13122937, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.PINK), "pink"),
    GREEN(4234555, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.GREEN), "green"),
    LIGHT_BLUE(2264319, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.LIGHT_BLUE), "lightBlue"),
    TURQUOISE(295304, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.CYAN), "turquoise"),
    YELLOW(14787335, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.YELLOW), "yellow"),
    LILAC(5055651, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.PURPLE), "lilac"),
    LEMON(9547787, MapColor.field_151669_i, "lemon"),
    PLUM(8588188, MapColor.field_151675_r, "plum"),
    CYAN(4901835, MapColor.field_151648_G, "cyan"),
    TANGERINE(15369542, MapColor.field_193562_N, "peach"),
    MINT(570994, MapColor.field_151674_s, "mint"),
    CHERRY(14831461, MapColor.field_193567_S, "cherry"),
    NEON_PINK(13567078, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.PINK), "neonPink"),
    NEON_GREEN(1550349, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.GREEN), "neonGreen"),
    NEON_ORANGE(15225863, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.ORANGE), "neonOrange"),
    NEON_BLUE(3017909, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.BLUE), "neonBlue"),
    SQUID(0xBDDD00, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.YELLOW), "squid"),
    OCTO(15014750, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.MAGENTA), "octo"),
    MOJANG(14623791, MapColor.field_193559_aa, "mojangRed"),
    COBALT(22146, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.CYAN), "cobalt"),
    ICEARSTORM(8978369, MapColor.field_151674_s, "icearstorm"),
    FLORAL(16751598, MapColor.field_151671_v, "floral"),
    DYE_WHITE(0xFAFAFA, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.WHITE), "dyeWhite", EnumDyeColor.WHITE),
    DYE_ORANGE(16351261, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.ORANGE), "dyeOrange", EnumDyeColor.ORANGE),
    DYE_MAGENTA(13061821, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.MAGENTA), "dyeMagenta", EnumDyeColor.MAGENTA),
    DYE_LIGHT_BLUE(3847130, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.LIGHT_BLUE), "dyeLightBlue", EnumDyeColor.LIGHT_BLUE),
    DYE_YELLOW(16701501, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.YELLOW), "dyeYellow", EnumDyeColor.YELLOW),
    DYE_LIME(8439583, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.LIME), "dyeLime", EnumDyeColor.LIME),
    DYE_PINK(15961002, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.PINK), "dyePink", EnumDyeColor.PINK),
    DYE_GRAY(4673362, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.GRAY), "dyeGray", EnumDyeColor.GRAY),
    DYE_SILVER(0x9D9D97, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.SILVER), "dyeSilver", EnumDyeColor.SILVER),
    DYE_CYAN(1481884, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.CYAN), "dyeCyan", EnumDyeColor.CYAN),
    DYE_PURPLE(8991416, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.PURPLE), "dyePurple", EnumDyeColor.PURPLE),
    DYE_BLUE(3949738, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.BLUE), "dyeBlue", EnumDyeColor.BLUE),
    DYE_BROWN(8606770, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.BROWN), "dyeBrown", EnumDyeColor.BROWN),
    DYE_GREEN(6192150, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.GREEN), "dyeGreen", EnumDyeColor.GREEN),
    DYE_RED(11546150, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.RED), "dyeRed", EnumDyeColor.RED),
    DYE_BLACK(0x1D1D21, MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.BLACK), "dyeBlack", EnumDyeColor.BLACK),
    INK_BLACK(2039597, MapColor.field_193570_V, "default");

    public static final List<InkColors> creativeTabColors;
    public static final List<InkColors> starterColors;
    private final int color;
    private final MapColor mapColor;
    private final String name;
    private final EnumDyeColor dyeColor;
    private static final Map<String, InkColors> BY_NAME;
    private static final Map<Integer, InkColors> BY_INT;

    private InkColors(Integer color, MapColor mapColor, String displayName, EnumDyeColor dyeColor) {
        this.color = color;
        this.mapColor = mapColor;
        this.name = displayName;
        this.dyeColor = dyeColor;
    }

    private InkColors(Integer color, MapColor mapColor, String displayName) {
        this(color, mapColor, displayName, null);
    }

    public static InkColors addColor(String name, int color, MapColor mapColor, String unlocalizedName) {
        return (InkColors)EnumHelper.addEnum(InkColors.class, (String)name, (Class[])new Class[]{Integer.class, MapColor.class, String.class}, (Object[])new Object[]{color, mapColor, unlocalizedName});
    }

    public static List<InkColors> getStarterColorArray() {
        return starterColors;
    }

    public static InkColors getRandomStarterColor() {
        return starterColors.get((int)(Math.random() * (double)starterColors.size()));
    }

    public int getColor() {
        return this.color;
    }

    public static InkColors getByColor(int color) {
        return BY_INT.get(color);
    }

    public static InkColors getByName(String name) {
        return BY_NAME.get(name);
    }

    public static Set<String> getNameSet() {
        return BY_NAME.keySet();
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public String getName() {
        return this.name;
    }

    public EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    static {
        creativeTabColors = new ArrayList<InkColors>(){
            {
                this.add(ORANGE);
                this.add(BLUE);
                this.add(GREEN);
                this.add(PINK);
            }
        };
        starterColors = new ArrayList<InkColors>(){
            {
                this.add(ORANGE);
                this.add(BLUE);
                this.add(GREEN);
                this.add(PINK);
            }
        };
        BY_NAME = Maps.newHashMap();
        BY_INT = Maps.newHashMap();
        for (InkColors color : InkColors.values()) {
            BY_NAME.put(color.getName(), color);
            BY_INT.put(color.getColor(), color);
        }
    }
}

